/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool;

import com.google.appengine.repackaged.com.google.common.flags.DocLevel;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.FlagSpec;
import com.google.appengine.repackaged.com.google.common.flags.Flags;
import com.google.cloud.sql.tool.Command;
import com.google.cloud.sql.tool.CommandException;
import com.google.cloud.sql.tool.CommandProcessor;
import com.google.cloud.sql.tool.Commands;
import com.google.cloud.sql.tool.Context;
import com.google.cloud.sql.tool.Log;
import com.google.cloud.sql.tool.SqlConsole;
import com.google.cloud.sql.tool.SqlProcessor;
import com.google.cloud.sql.tool.commands.ClearStatementCommand;
import com.google.cloud.sql.tool.commands.DelimiterCommand;
import com.google.cloud.sql.tool.commands.HelpCommand;
import com.google.cloud.sql.tool.commands.NoTeeCommand;
import com.google.cloud.sql.tool.commands.NoWarningsCommand;
import com.google.cloud.sql.tool.commands.ShutdownCommand;
import com.google.cloud.sql.tool.commands.SourceCommand;
import com.google.cloud.sql.tool.commands.TeeCommand;
import com.google.cloud.sql.tool.commands.WarningsCommand;
import com.google.cloud.sql.tool.connections.ConnectionException;
import com.google.cloud.sql.tool.connections.ConnectionFactory;
import com.google.cloud.sql.tool.connections.FlagsConnectionFactory;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Sql {
    @FlagSpec(help="Log extra diagnostic information.", docLevel=DocLevel.SECRET)
    private static final Flag<Boolean> verbose = Flag.value(false);
    @FlagSpec(help="JDBC URL for connecting to the server. Example: jdbc:google:rdbms://gmail.com:myinstance")
    private static final Flag<String> url = Flag.value("");
    @FlagSpec(help="Connection Properties")
    private static final Flag<Map<String, String>> properties = Flag.stringMap(new HashMap<String, String>());
    @FlagSpec(altName="connection_factory", docLevel=DocLevel.SECRET, help="Connection factory to use to Connect")
    private static final Flag<Class<? extends ConnectionFactory>> connectionFactory = Flag.value(FlagsConnectionFactory.class, ConnectionFactory.class);
    static final String UNABLE_TO_RECOVER_MESSAGE = "Unable to recover from this error without restarting.";
    private static final Commands COMMANDS = new Commands();
    static final Context CONTEXT = new Context(COMMANDS);
    protected final CommandProcessor cp;
    protected final SqlProcessor sql;
    private final SqlConsole console;
    private final boolean hasTerminal;

    Sql(CommandProcessor cp, SqlProcessor sql, SqlConsole console, boolean hasTerminal) {
        this.cp = cp;
        this.sql = sql;
        this.console = console;
        this.hasTerminal = hasTerminal;
    }

    static Sql create(CommandProcessor cp, SqlProcessor sql, SqlConsole console, boolean hasTerminal) {
        return new Sql(cp, sql, console, hasTerminal);
    }

    Sql createChild(SqlConsole console, boolean piped) {
        return Sql.create(this.cp, this.sql, console, piped);
    }

    public int run() {
        while (true) {
            try {
                String line;
                Command.Result result;
                do {
                    String prompt = CONTEXT.hasCurrentStatement() ? "-> " : "sql> ";
                    line = this.console.readLine(prompt);
                    CONTEXT.getFileWriter().print(prompt);
                    CONTEXT.getFileWriter().println(line);
                } while ((result = this.processLine(line)) != Command.Result.SHUTDOWN);
            }
            catch (EOFException e) {
                if (!this.hasTerminal) {
                    if (!CONTEXT.hasCurrentStatement()) break;
                    try {
                        this.sql.execute(SqlProcessor.PrintMode.TABULAR);
                    }
                    catch (SQLException sqlEx) {
                        this.handleException(sqlEx);
                    }
                    break;
                }
                this.handleException(e);
            }
            catch (CommandException e) {
                this.handleException(e);
                continue;
            }
            catch (SQLException e) {
                if (!this.handleSqlException(e)) continue;
            }
            catch (IOException e) {
                this.handleException(e);
                continue;
            }
            break;
        }
        return 0;
    }

    protected Command.Result processLine(String commandLine) throws SQLException, CommandException {
        if (commandLine == null) {
            Log.vlog("no input", new Object[0]);
            return Command.Result.EMPTY;
        }
        String line = commandLine.trim();
        Command.Result result = this.cp.processCommand(line);
        if (result == Command.Result.NOT_COMMAND) {
            this.sql.processSql(line);
        }
        return result;
    }

    protected void handleException(Exception e) {
        PrintWriter out = CONTEXT.getWriter();
        out.println(e.getLocalizedMessage());
        out.flush();
        Log.logException(e);
    }

    protected boolean handleSqlException(SQLException e) {
        PrintWriter out = CONTEXT.getWriter();
        out.printf("ERROR %d (SQLSTATE %s): %s\n", e.getErrorCode(), e.getSQLState(), e.getLocalizedMessage());
        out.flush();
        Log.logException(e);
        if (e instanceof SQLRecoverableException) {
            out.print(UNABLE_TO_RECOVER_MESSAGE);
            out.flush();
            return true;
        }
        return false;
    }

    private void registerCommands() {
        COMMANDS.registerCommand(new ClearStatementCommand());
        COMMANDS.registerCommand(new DelimiterCommand());
        COMMANDS.registerCommand(new HelpCommand());
        COMMANDS.registerCommand(new NoTeeCommand());
        COMMANDS.registerCommand(new NoWarningsCommand());
        COMMANDS.registerCommand(new ShutdownCommand());
        COMMANDS.registerCommand(new TeeCommand());
        COMMANDS.registerCommand(new WarningsCommand());
        COMMANDS.registerCommand(new SourceCommand(new SqlChildCreatorImpl()));
    }

    protected void close() {
        this.console.out("Bye");
        if (this.sql != null) {
            this.sql.close();
        }
    }

    private static Connection openConnection() {
        try {
            ConnectionFactory factory = connectionFactory.get().newInstance();
            return factory.connect(url.get(), properties.get());
        }
        catch (ConnectionException e) {
            Sql.exit(3, "Exiting; Unable to open connection.", e);
        }
        catch (SQLException e) {
            Sql.exit(3, "Exiting; Unable to open connection.", e);
        }
        catch (InstantiationException e) {
            Sql.exit(3, "Exiting; Unable to open connection.", e);
        }
        catch (IllegalAccessException e) {
            Sql.exit(3, "Exiting; Unable to open connection.", e);
        }
        throw new IllegalStateException("not possible");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Logger.getLogger("").setLevel(Level.OFF);
        Flags.parse(args);
        if (verbose.get().booleanValue()) {
            Log.setVerbose(true);
            Log.vlog("Enabling verbose mode.", new Object[0]);
        }
        int exitCode = 0;
        Sql tool = null;
        try {
            Connection connection = Sql.openConnection();
            boolean hasTerminal = SqlConsole.hasTerminal();
            SqlProcessor sql = new SqlProcessor(connection, CONTEXT, hasTerminal);
            tool = Sql.create(new CommandProcessor(COMMANDS, CONTEXT), sql, SqlConsole.create(), hasTerminal);
            tool.registerCommands();
            sql.initialize();
            exitCode = tool.run();
        }
        catch (Throwable t) {
            t.printStackTrace(CONTEXT.getWriter());
            exitCode = 1;
        }
        finally {
            if (tool != null) {
                tool.close();
            }
            Sql.exit(exitCode, null, null);
        }
    }

    static void exit(int exitCode, String message, Throwable t) {
        PrintWriter out = CONTEXT.getWriter();
        if (message != null) {
            out.println(message);
        }
        if (t != null) {
            out.println(t.getMessage());
            Log.logException(t);
        }
        out.flush();
        System.exit(exitCode);
    }

    class SqlChildCreatorImpl
    implements SqlChildCreator {
        SqlChildCreatorImpl() {
        }

        @Override
        public Sql create(SqlConsole console) {
            return Sql.this.createChild(console, false);
        }
    }

    public static interface SqlChildCreator {
        public Sql create(SqlConsole var1);
    }
}

