/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.StorageVersion;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MetaDataManager;

public class MetaDataUtils {
    public static String getDefaultValueForMember(AbstractMemberMetaData mmd) {
        ColumnMetaData[] colmds = mmd.getColumnMetaData();
        if (colmds == null || colmds.length < 1) {
            return null;
        }
        return colmds[0].getDefaultValue();
    }

    public static boolean hasEncodedPKField(AbstractClassMetaData acmd) {
        if (acmd.getIdentityType() == IdentityType.DATASTORE) {
            IdentityMetaData idmd = acmd.getIdentityMetaData();
            return idmd.hasExtension("gae.encoded-pk");
        }
        int pkFieldNumber = acmd.getPKMemberPositions()[0];
        return MetaDataUtils.isEncodedPKField(acmd, pkFieldNumber);
    }

    public static boolean isEncodedPKField(AbstractClassMetaData acmd, int fieldNumber) {
        return MetaDataUtils.isEncodedPKField(acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public static boolean isEncodedPKField(AbstractMemberMetaData ammd) {
        return ammd.hasExtension("gae.encoded-pk");
    }

    public static boolean isParentPKField(AbstractClassMetaData acmd, int fieldNumber) {
        return MetaDataUtils.isParentPKField(acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public static boolean isParentPKField(AbstractMemberMetaData ammd) {
        return ammd.hasExtension("gae.parent-pk");
    }

    public static boolean isPKNameField(AbstractClassMetaData acmd, int fieldNumber) {
        return MetaDataUtils.isPKNameField(acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public static boolean isPKNameField(AbstractMemberMetaData ammd) {
        return ammd.hasExtension("gae.pk-name");
    }

    public static boolean isPKIdField(AbstractClassMetaData acmd, int fieldNumber) {
        return MetaDataUtils.isPKIdField(acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public static boolean isPKIdField(AbstractMemberMetaData ammd) {
        return ammd.hasExtension("gae.pk-id");
    }

    public static boolean isNewOrSuperclassTableInheritanceStrategy(AbstractClassMetaData cmd) {
        while (cmd != null) {
            AbstractClassMetaData pcmd = cmd.getSuperAbstractClassMetaData();
            if (pcmd == null) {
                return cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.NEW_TABLE;
            }
            if (cmd.getInheritanceMetaData().getStrategy() != InheritanceStrategy.SUPERCLASS_TABLE) {
                return false;
            }
            cmd = pcmd;
        }
        return false;
    }

    public static boolean isOwnedRelation(AbstractMemberMetaData mmd) {
        boolean owned = true;
        if ("true".equalsIgnoreCase(mmd.getValueForExtension("gae.unowned"))) {
            owned = false;
        }
        return owned;
    }

    public static boolean readRelatedKeysFromParent(DatastoreManager storeMgr, AbstractMemberMetaData mmd) {
        return !MetaDataUtils.isOwnedRelation(mmd) || storeMgr.storageVersionAtLeast(StorageVersion.READ_OWNED_CHILD_KEYS_FROM_PARENTS);
    }

    public static AbstractMemberMetaData getParentPkMemberMetaDataForClass(AbstractClassMetaData cmd, MetaDataManager mmgr, ClassLoaderResolver clr) {
        AbstractMemberMetaData[] mmds = cmd.getManagedMembers();
        for (int i = 0; i < mmds.length; ++i) {
            AbstractClassMetaData embCmd;
            AbstractMemberMetaData embPkParentMmd;
            if (MetaDataUtils.isParentPKField(mmds[i])) {
                return mmds[i];
            }
            if (mmds[i].getEmbeddedMetaData() == null || (embPkParentMmd = MetaDataUtils.getParentPkMemberMetaDataForClass(embCmd = mmgr.getMetaDataForClass(mmds[i].getType(), clr), mmgr, clr)) == null) continue;
            return embPkParentMmd;
        }
        AbstractClassMetaData superCmd = cmd.getSuperAbstractClassMetaData();
        if (superCmd != null) {
            return MetaDataUtils.getParentPkMemberMetaDataForClass(superCmd, mmgr, clr);
        }
        return null;
    }
}

