/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.channel.dev;

import com.google.appengine.api.channel.dev.LocalChannelFailureException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

class Channel {
    public static final String CONNECTION_ID_PREFIX = "connection-";
    private final String clientId;
    private final AtomicInteger idAllocator;
    private final Map<String, Queue<String>> messageQueues;

    Channel(String clientId) {
        this.clientId = clientId;
        this.idAllocator = new AtomicInteger();
        this.messageQueues = new HashMap<String, Queue<String>>();
    }

    Map<String, Queue<String>> getMessageQueues() {
        return this.messageQueues;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String connectClient() {
        String connectionId = CONNECTION_ID_PREFIX + this.idAllocator.getAndIncrement();
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
        this.messageQueues.put(connectionId, queue);
        return connectionId;
    }

    public void disconnectClient(String connectionId) {
        this.messageQueues.remove(connectionId);
    }

    public Queue<String> getClientMessageQueue(String connectionId) {
        if (this.messageQueues.containsKey(connectionId)) {
            return this.messageQueues.get(connectionId);
        }
        throw new LocalChannelFailureException("Client connection with ID " + connectionId + " not found.");
    }

    public void sendMessage(String message) {
        for (Queue<String> queue : this.messageQueues.values()) {
            queue.add(message);
        }
    }
}

