/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.appengine.api.rdbms.dev.LocalConnection;
import com.google.cloud.sql.jdbc.internal.DataTypeConverter;
import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.ExecRequest;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public final class Statements {
    private static final int DEFAULT_FETCH_SIZE = 100;

    private Statements() {
    }

    static Statement buildStatement(LocalConnection conn, ExecRequest request) throws SQLException {
        Client.ExecOptions options = request.getOptions();
        int resultSetType = options.hasType() ? options.getType().getNumber() : 1003;
        int resultSetConcurrency = options.hasConcurrency() ? options.getConcurrency().getNumber() : 1007;
        int resultSetHoldability = options.hasHoldability() ? options.getHoldability().getNumber() : 2;
        Statement stmt = conn.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        if (options.hasMaxRows()) {
            stmt.setMaxRows(options.getMaxRows());
        }
        if (options.hasFetchSize()) {
            int fetchSize = options.getFetchSize();
            if (fetchSize == Integer.MIN_VALUE) {
                fetchSize = 100;
            }
            stmt.setFetchSize(fetchSize);
        }
        if (Statements.isBatch(request)) {
            for (String sql : request.getBatch().getStatementList()) {
                stmt.addBatch(sql);
            }
        }
        return stmt;
    }

    static boolean getGeneratedKeys(LocalConnection conn, ExecRequest request) throws SQLException {
        return request.getOptions().getIncludeGeneratedKeys() && conn.getMetaData().supportsGetGeneratedKeys();
    }

    static boolean isBatch(ExecRequest request) {
        if (request.hasBatch()) {
            Client.BatchProto batch = request.getBatch();
            return batch.getBatchBindVariableCount() > 0 || batch.getStatementCount() > 0;
        }
        return false;
    }

    static PreparedStatement buildPreparedStatement(LocalConnection conn, ExecRequest request) throws SQLException {
        PreparedStatement ps = Statements.getGeneratedKeys(conn, request) ? conn.getConnection().prepareStatement(request.getStatement(), 1) : conn.getConnection().prepareStatement(request.getStatement());
        Statements.bindPreparedStatementInputVariables(request, ps);
        return ps;
    }

    static CallableStatement buildCallableStatement(LocalConnection conn, ExecRequest request) throws SQLException {
        CallableStatement cs = conn.getConnection().prepareCall(request.getStatement());
        Statements.bindCallableStatementInputVariables(request, cs);
        for (Client.BindVariableProto bv : request.getBindVariableList()) {
            if (bv.getDirection() == Client.BindVariableProto.Direction.IN) continue;
            if (bv.hasPosition()) {
                cs.registerOutParameter(bv.getPosition(), bv.getType());
                continue;
            }
            if (!bv.hasName()) continue;
            cs.registerOutParameter(bv.getName(), bv.getType());
        }
        return cs;
    }

    private static void bindPreparedStatementInputVariables(ExecRequest request, PreparedStatement ps) throws SQLException {
        if (Statements.isBatch(request)) {
            for (Client.BatchBindVariableProto bbv : request.getBatch().getBatchBindVariableList()) {
                Statements.bindPreparedStatementInputVariables(request, ps, bbv.getBindVariableList());
                ps.addBatch();
            }
        } else {
            Statements.bindPreparedStatementInputVariables(request, ps, request.getBindVariableList());
        }
    }

    private static void bindPreparedStatementInputVariables(ExecRequest request, PreparedStatement ps, List<Client.BindVariableProto> bvs) throws SQLException {
        for (Client.BindVariableProto bv : bvs) {
            if (bv.getDirection() == Client.BindVariableProto.Direction.OUT) continue;
            DataTypeConverter converter = JdbcType.fromCode((int)bv.getType()).getConverter();
            if (bv.hasValue()) {
                ps.setObject(bv.getPosition(), converter.toObject(bv.getValue()));
                continue;
            }
            ps.setNull(bv.getPosition(), bv.getType());
        }
    }

    private static void bindCallableStatementInputVariables(ExecRequest request, CallableStatement ps) throws SQLException {
        if (Statements.isBatch(request)) {
            for (Client.BatchBindVariableProto bbv : request.getBatch().getBatchBindVariableList()) {
                Statements.bindCallableStatementInputVariables(request, ps, bbv.getBindVariableList());
                ps.addBatch();
            }
        } else {
            Statements.bindCallableStatementInputVariables(request, ps, request.getBindVariableList());
        }
    }

    private static void bindCallableStatementInputVariables(ExecRequest request, CallableStatement ps, List<Client.BindVariableProto> bvs) throws SQLException {
        for (Client.BindVariableProto bv : bvs) {
            if (bv.getDirection() == Client.BindVariableProto.Direction.OUT) continue;
            DataTypeConverter converter = JdbcType.fromCode((int)bv.getType()).getConverter();
            if (bv.hasValue()) {
                if (bv.hasPosition()) {
                    ps.setObject(bv.getPosition(), converter.toObject(bv.getValue()));
                    continue;
                }
                ps.setObject(bv.getName(), converter.toObject(bv.getValue()));
                continue;
            }
            if (bv.hasPosition()) {
                ps.setNull(bv.getPosition(), bv.getType());
                continue;
            }
            ps.setNull(bv.getName(), bv.getType());
        }
    }
}

