/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.lang.reflect.Array;
import java.util.List;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.scostore.ArrayStore;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.util.NucleusLogger;

public class ArrayMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    public Class getJavaType() {
        if (this.mmd != null) {
            return this.mmd.getType();
        }
        return null;
    }

    protected boolean containerIsStoredInSingleColumn() {
        if (super.containerIsStoredInSingleColumn()) {
            return true;
        }
        return this.mmd != null && this.mmd.hasArray() && this.mmd.getJoinMetaData() == null && MetaDataUtils.getInstance().arrayStorableAsByteArrayInSingleColumn(this.mmd);
    }

    public void insertPostProcessing(ObjectProvider op) {
    }

    public void postInsert(ObjectProvider ownerOP) {
        ExecutionContext ec = ownerOP.getExecutionContext();
        Object value = ownerOP.provideField(this.mmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting(ec, value);
            return;
        }
        if (value == null) {
            return;
        }
        if (!this.mmd.isCascadePersist()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007006", (Object)this.mmd.getFullFieldName()));
            }
            if (!this.mmd.getType().getComponentType().isPrimitive()) {
                Object[] array = (Object[])value;
                for (int i = 0; i < array.length; ++i) {
                    if (ec.getApiAdapter().isDetached(array[i]) || ec.getApiAdapter().isPersistent(array[i])) continue;
                    throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), array[i]);
                }
            }
        } else {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007007", (Object)this.mmd.getFullFieldName()));
            }
            ((ArrayStore)this.storeMgr.getBackingStoreForField(ownerOP.getExecutionContext().getClassLoaderResolver(), this.mmd, null)).set(ownerOP, value);
        }
    }

    public void postFetch(ObjectProvider sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        List elements = ((ArrayStore)this.storeMgr.getBackingStoreForField(sm.getExecutionContext().getClassLoaderResolver(), this.mmd, null)).getArray(sm);
        if (elements != null) {
            boolean primitiveArray = this.mmd.getType().getComponentType().isPrimitive();
            Object array = Array.newInstance(this.mmd.getType().getComponentType(), elements.size());
            for (int i = 0; i < elements.size(); ++i) {
                Object element = elements.get(i);
                if (primitiveArray) {
                    if (element instanceof Boolean) {
                        Array.setBoolean(array, i, (Boolean)element);
                        continue;
                    }
                    if (element instanceof Byte) {
                        Array.setByte(array, i, (Byte)element);
                        continue;
                    }
                    if (element instanceof Character) {
                        Array.setChar(array, i, ((Character)element).charValue());
                        continue;
                    }
                    if (element instanceof Double) {
                        Array.setDouble(array, i, (Double)element);
                        continue;
                    }
                    if (element instanceof Float) {
                        Array.setFloat(array, i, ((Float)element).floatValue());
                        continue;
                    }
                    if (element instanceof Integer) {
                        Array.setInt(array, i, (Integer)element);
                        continue;
                    }
                    if (element instanceof Long) {
                        Array.setLong(array, i, (Long)element);
                        continue;
                    }
                    if (!(element instanceof Short)) continue;
                    Array.setShort(array, i, (Short)element);
                    continue;
                }
                Array.set(array, i, element);
            }
            if (elements.size() == 0) {
                sm.replaceFieldMakeDirty(this.mmd.getAbsoluteFieldNumber(), null);
            } else {
                sm.replaceFieldMakeDirty(this.mmd.getAbsoluteFieldNumber(), array);
            }
        } else {
            sm.replaceFieldMakeDirty(this.mmd.getAbsoluteFieldNumber(), null);
        }
    }

    public void postUpdate(ObjectProvider ownerOP) {
        ExecutionContext ec = ownerOP.getExecutionContext();
        Object value = ownerOP.provideField(this.mmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting(ec, value);
            return;
        }
        if (value == null) {
            ((ArrayStore)this.storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, null)).clear(ownerOP);
            return;
        }
        if (!this.mmd.isCascadeUpdate()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007008", (Object)this.mmd.getFullFieldName()));
            }
            return;
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007009", (Object)this.mmd.getFullFieldName()));
        }
        ArrayStore backingStore = (ArrayStore)this.storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, null);
        backingStore.clear(ownerOP);
        backingStore.set(ownerOP, value);
    }

    public void preDelete(ObjectProvider sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        sm.getExecutionContext().getApiAdapter().isLoaded(sm, this.mmd.getAbsoluteFieldNumber());
        Object value = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        ArrayStore backingStore = (ArrayStore)this.storeMgr.getBackingStoreForField(sm.getExecutionContext().getClassLoaderResolver(), this.mmd, null);
        backingStore.clear(sm);
    }
}

