/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.Conversion;
import com.google.appengine.api.conversion.ConversionHelper;
import com.google.appengine.api.conversion.ConversionOptions;
import com.google.appengine.api.conversion.ConversionServicePb;
import com.google.appengine.api.conversion.Document;
import com.google.appengine.api.conversion.DocumentProtoConverter;
import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.StringUtil;

class ConversionProtoConverter
extends Converter<Conversion, ConversionServicePb.ConversionInput> {
    private static final String IMAGE_WIDTH_FLAG = "imageWidth";
    private static final String FIRST_PAGE_FLAG = "firstPage";
    private static final String LAST_PAGE_FLAG = "lastPage";
    private static final String INPUT_LANGUAGE_FLAG = "input_language_hint";
    private final DocumentProtoConverter documentProtoConverter = new DocumentProtoConverter();

    ConversionProtoConverter() {
    }

    @Override
    public ConversionServicePb.ConversionInput doForward(Conversion conversion) {
        ConversionHelper.validateInputDoc(conversion.getInputDoc());
        Preconditions.checkArgument(!StringUtil.isEmptyOrWhitespace(conversion.getOutputMimeType()), "Output mime type should not be null, empty or comprises only whitespace characters");
        ConversionServicePb.ConversionInput.Builder builder = ConversionServicePb.ConversionInput.newBuilder();
        builder.setInput((ConversionServicePb.DocumentInfo)this.documentProtoConverter.convert(conversion.getInputDoc())).setOutputMimeType(conversion.getOutputMimeType());
        ConversionOptions options = conversion.getOptions();
        builder.addFlag(ConversionProtoConverter.createAuxData(IMAGE_WIDTH_FLAG, Integer.toString(options.getImageWidth())));
        builder.addFlag(ConversionProtoConverter.createAuxData(FIRST_PAGE_FLAG, Integer.toString(options.getFirstPage())));
        builder.addFlag(ConversionProtoConverter.createAuxData(LAST_PAGE_FLAG, Integer.toString(options.getLastPage())));
        if (options.getOcrInputLanguage() != null) {
            builder.addFlag(ConversionProtoConverter.createAuxData(INPUT_LANGUAGE_FLAG, options.getOcrInputLanguage()));
        }
        return builder.build();
    }

    @Override
    public Conversion doBackward(ConversionServicePb.ConversionInput conversionPb) {
        return new Conversion((Document)this.documentProtoConverter.reverse(conversionPb.getInput()), conversionPb.getOutputMimeType());
    }

    private static ConversionServicePb.ConversionInput.AuxData.Builder createAuxData(String key, String value) {
        return ConversionServicePb.ConversionInput.AuxData.newBuilder().setKey(key).setValue(value);
    }
}

