/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.el;

import com.google.appengine.repackaged.org.apache.commons.el.Coercions;
import com.google.appengine.repackaged.org.apache.commons.el.Constants;
import com.google.appengine.repackaged.org.apache.commons.el.Expression;
import com.google.appengine.repackaged.org.apache.commons.el.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;

public class FunctionInvocation
extends Expression {
    private String functionName;
    private List argumentList;

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String f) {
        this.functionName = f;
    }

    public List getArgumentList() {
        return this.argumentList;
    }

    public void setArgumentList(List l) {
        this.argumentList = l;
    }

    public FunctionInvocation(String functionName, List argumentList) {
        this.functionName = functionName;
        this.argumentList = argumentList;
    }

    public String getExpressionString() {
        StringBuffer b = new StringBuffer();
        b.append(this.functionName);
        b.append("(");
        Iterator i = this.argumentList.iterator();
        while (i.hasNext()) {
            b.append(((Expression)i.next()).getExpressionString());
            if (!i.hasNext()) continue;
            b.append(", ");
        }
        b.append(")");
        return b.toString();
    }

    public Object evaluate(VariableResolver pResolver, FunctionMapper functions, Logger pLogger) throws ELException {
        Class<?>[] params;
        if (functions == null) {
            pLogger.logError(Constants.UNKNOWN_FUNCTION, this.functionName);
        }
        String prefix = null;
        String localName = null;
        int index = this.functionName.indexOf(58);
        if (index == -1) {
            prefix = "";
            localName = this.functionName;
        } else {
            prefix = this.functionName.substring(0, index);
            localName = this.functionName.substring(index + 1);
        }
        Method target = functions.resolveFunction(prefix, localName);
        if (target == null) {
            pLogger.logError(Constants.UNKNOWN_FUNCTION, this.functionName);
        }
        if ((params = target.getParameterTypes()).length != this.argumentList.size()) {
            pLogger.logError(Constants.INAPPROPRIATE_FUNCTION_ARG_COUNT, this.functionName, (Object)new Integer(params.length), (Object)new Integer(this.argumentList.size()));
        }
        Object[] arguments = new Object[this.argumentList.size()];
        int i = 0;
        while (i < params.length) {
            arguments[i] = ((Expression)this.argumentList.get(i)).evaluate(pResolver, functions, pLogger);
            arguments[i] = Coercions.coerce(arguments[i], params[i], pLogger);
            ++i;
        }
        try {
            return target.invoke(null, arguments);
        }
        catch (InvocationTargetException ex) {
            pLogger.logError(Constants.FUNCTION_INVOCATION_ERROR, ex.getTargetException(), (Object)this.functionName);
            return null;
        }
        catch (Exception ex) {
            pLogger.logError(Constants.FUNCTION_INVOCATION_ERROR, ex, (Object)this.functionName);
            return null;
        }
    }
}

