/**********************************************************************
Copyright (c) 2004 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
2008 Andy Jefferson - added raw value concept
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

/**
 * Represents a Literal expression.
 * @version $Revision: 1.4 $
 */
public interface Literal
{
    /**
     * Accessor to the literal value
     * @return the value of the literal
     */
    Object getValue();

    /**
     * Method to save a "raw" value that this literal represents.
     * This value differs from the literal value since that is of the same type as this literal.
     * e.g An Enum can be represented as String or Integer, so we store the Enum as the "raw"
     * @param val The raw value
     */
    void setRawValue(Object val);

    /**
     * Accessor for the "raw" value that this literal represents.
     * This value differs from the literal value since that is of the same type as this literal.
     * @return The raw value
     */
    Object getRawValue();
}