/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.DialogMessage;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.TableLayout;
import org.basex.util.Util;

public abstract class BaseXDialog
extends JDialog
implements BaseXWindow {
    protected final GUI gui;
    final StringBuilder mnem = new StringBuilder();
    protected boolean ok;
    protected BaseXBack panel;
    public final KeyListener keys = e -> {
        if (!BaseXKeys.modifier(e) && e.getKeyChar() != '\uffff') {
            this.action(e.getSource());
        }
    };

    protected BaseXDialog(BaseXDialog dialog, String title) {
        super(dialog, title, true);
        this.gui = dialog.gui;
        this.init();
    }

    protected BaseXDialog(GUI gui, String title) {
        this(gui, title, true);
    }

    protected BaseXDialog(GUI gui, String title, boolean modal) {
        super(gui, title, modal);
        this.gui = gui;
        this.init();
    }

    private void init() {
        this.panel = new BaseXBack(new BorderLayout()).border(10, 10, 10, 10);
        this.add((Component)this.panel, "Center");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BaseXDialog.this.cancel();
            }
        });
    }

    protected final void set(Component comp, String pos) {
        this.panel.add(comp, pos);
    }

    protected final void finish() {
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.gui);
        this.setVisible(true);
    }

    public void action(Object source) {
    }

    public void cancel() {
        this.ok = false;
        this.dispose();
    }

    public void close() {
        this.ok = true;
        this.dispose();
    }

    @Override
    public void dispose() {
        this.gui.saveOptions();
        super.dispose();
    }

    public final boolean modal() {
        return this.getModalityType() != Dialog.ModalityType.MODELESS;
    }

    public final boolean ok() {
        return this.ok;
    }

    protected final BaseXBack okCancel() {
        return this.newButtons(Text.B_OK, Text.B_CANCEL);
    }

    public final BaseXBack newButtons(Object ... buttons) {
        BaseXBack pnl = new BaseXBack(false).border(12, 0, 0, 0).layout(new TableLayout(1, buttons.length, 8, 0));
        for (Object button : buttons) {
            BaseXButton b;
            pnl.add(button instanceof BaseXButton ? (b = (BaseXButton)button) : new BaseXButton(this, button.toString()));
        }
        BaseXBack button = new BaseXBack(false).layout(new BorderLayout());
        button.add((Component)pnl, "East");
        return button;
    }

    protected static void enableOK(JComponent panel, String label, boolean enabled) {
        for (Component comp : panel.getComponents()) {
            if (comp instanceof BaseXButton) {
                BaseXButton button = (BaseXButton)comp;
                if (!button.getText().equals(label)) continue;
                button.setEnabled(enabled);
                continue;
            }
            if (!(comp instanceof JComponent)) continue;
            JComponent jcomp = (JComponent)comp;
            BaseXDialog.enableOK(jcomp, label, enabled);
        }
    }

    public static String yesNoCancel(GUI gui, String text, String ... buttons) {
        return new DialogMessage(gui, text.trim(), GUIConstants.Msg.YESNOCANCEL, buttons).action();
    }

    public static boolean confirm(GUI gui, String text) {
        return Text.B_YES.equals(new DialogMessage(gui, text.trim(), GUIConstants.Msg.QUESTION, new String[0]).action());
    }

    public static void error(GUI gui, String text) {
        new DialogMessage(gui, text.trim(), GUIConstants.Msg.ERROR, new String[0]);
    }

    public static void browse(GUI gui, String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception ex) {
            Util.debug(ex);
            BaseXDialog.error(gui, Util.info(Text.H_BROWSER_ERROR_X, Text.PUBLIC_URL));
        }
    }

    @Override
    public GUI gui() {
        return this.gui;
    }

    @Override
    public BaseXDialog dialog() {
        return this;
    }

    @Override
    public BaseXDialog component() {
        return this;
    }
}

