/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import org.basex.core.Text;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.Closure;
import org.basex.query.func.Functions;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.func.java.JavaCall;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.list.AnnList;
import org.basex.query.util.parse.Params;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.list.IntList;
import org.basex.util.similarity.Levenshtein;

public final class StaticFuncs
extends ExprInfo {
    private final TokenObjectMap<FuncCache> caches = new TokenObjectMap();
    private Map<StaticFunc, ArrayList<StaticFuncCall>> callsMap;

    public StaticFunc declare(QNm name, Params params, Expr expr, AnnList anns, String doc, VarScope vs, InputInfo info) throws QueryException {
        byte[] uri = name.uri();
        if (uri.length == 0) {
            throw QueryError.FUNNONS_X.get(info, new Object[]{name.string()});
        }
        if (NSGlobal.reserved(uri) || Functions.builtIn(name) != null) {
            throw QueryError.FNRESERVED_X.get(info, new Object[]{name.string()});
        }
        StaticFunc sf = new StaticFunc(name, params, expr, anns, vs, info, doc);
        if (!this.cache(name.prefixId()).register(sf)) {
            throw QueryError.DUPLFUNC_X.get(sf.info, new Object[]{name.string()});
        }
        return sf;
    }

    void register(StaticFuncCall call) throws QueryException {
        this.cache(call.name.prefixId()).add(call);
    }

    public void register(Closure closure) {
        this.cache(closure.funcName().prefixId()).add(closure);
    }

    public void check(QueryContext qc) throws QueryException {
        for (FuncCache cache : this.caches.values()) {
            cache.init(qc);
        }
    }

    public void checkUp() throws QueryException {
        for (FuncCache cache : this.caches()) {
            for (StaticFunc func : cache.funcs) {
                func.checkUp();
            }
        }
    }

    public void compileAll(CompileContext cc) {
        for (FuncCache cache : this.caches()) {
            for (StaticFunc func : cache.funcs) {
                func.compile(cc);
            }
        }
    }

    public StaticFunc get(QNm qname, long arity) {
        FuncCache cache = this.caches.get(qname.prefixId());
        if (cache != null) {
            for (StaticFunc func : cache.funcs) {
                if (arity < (long)func.min || arity > (long)func.arity()) continue;
                return func;
            }
        }
        return null;
    }

    SeqType[] seqTypes(StaticFunc func) {
        if (this.callsMap == null) {
            this.callsMap = new IdentityHashMap<StaticFunc, ArrayList<StaticFuncCall>>();
            for (FuncCache cache : this.caches()) {
                for (StaticFuncCall call : cache.calls) {
                    this.callsMap.computeIfAbsent(call.func, k -> new ArrayList(1)).add(call);
                }
            }
        }
        ArrayList<StaticFuncCall> calls = this.callsMap.get(func);
        int sl = func.arity();
        if (calls == null || calls.isEmpty() || sl == 0) {
            return null;
        }
        SeqType[] seqTypes = new SeqType[sl];
        for (StaticFuncCall call : calls) {
            for (int s = 0; s < sl; ++s) {
                SeqType st = call.arg(s).seqType();
                SeqType stOld = seqTypes[s];
                seqTypes[s] = stOld == null ? st : stOld.union(st);
            }
        }
        return seqTypes;
    }

    public QueryException similarError(QNm qname, InputInfo info) {
        ArrayList<QNm> list = new ArrayList<QNm>();
        block0: for (FuncCache cache : this.caches()) {
            for (StaticFunc func : cache.funcs) {
                if (func.expr == null) continue;
                list.add(cache.qname());
                continue block0;
            }
        }
        Object similar = Levenshtein.similar(qname.local(), list.toArray(QNm[]::new), o -> ((QNm)o).local());
        return QueryError.WHICHFUNC_X.get(info, new Object[]{similar != null ? QueryError.similar(qname.prefixString(), ((QNm)similar).prefixString()) : Functions.similar(qname)});
    }

    public StaticFunc[] funcs() {
        ArrayList<StaticFunc> list = new ArrayList<StaticFunc>();
        for (FuncCache cache : this.caches()) {
            list.addAll(cache.funcs);
        }
        return (StaticFunc[])list.toArray(StaticFunc[]::new);
    }

    @Override
    public void toXml(QueryPlan plan) {
        if (!this.caches.isEmpty()) {
            plan.add(plan.create(this, new Object[0]), this.funcs());
        }
    }

    @Override
    public void toString(QueryString qs) {
        for (FuncCache cache : this.caches()) {
            for (StaticFunc func : cache.funcs) {
                if (!func.compiled()) continue;
                qs.token(func).token(Text.NL);
            }
        }
    }

    private ArrayList<FuncCache> caches() {
        ArrayList<FuncCache> list = new ArrayList<FuncCache>();
        for (FuncCache cache : this.caches.values()) {
            if (cache.funcs.isEmpty()) continue;
            list.add(cache);
        }
        return list;
    }

    private FuncCache cache(byte[] id) {
        return this.caches.computeIfAbsent(id, FuncCache::new);
    }

    private static final class FuncCache {
        final ArrayList<StaticFunc> funcs = new ArrayList(1);
        final ArrayList<StaticFuncCall> calls = new ArrayList(0);
        final ArrayList<Closure> closures = new ArrayList(0);

        private FuncCache() {
        }

        void init(QueryContext qc) throws QueryException {
            for (StaticFuncCall call : this.calls) {
                if (call.func == null && !this.setFunc(call) && !this.setJava(call, qc)) {
                    if (this.calls.isEmpty()) continue;
                    IntList arities = new IntList();
                    for (StaticFunc func : this.funcs) {
                        arities.add(func.min).add(func.arity());
                    }
                    InputInfo info = call.info();
                    throw arities.isEmpty() ? qc.functions.similarError(this.qname(), info) : Functions.wrongArity(call.arity(), arities, false, info, this.qname().prefixString());
                }
                StaticFunc func = call.func;
                if (func != null) {
                    if (!call.hasImport) {
                        byte[] callModUri;
                        QNm funcMod = func.sc.module;
                        QNm callMod = call.info().sc().module;
                        byte[] funcModUri = funcMod == null ? Token.EMPTY : funcMod.uri();
                        byte[] byArray = callModUri = callMod == null ? Token.EMPTY : callMod.uri();
                        if (!Token.eq(funcModUri, callModUri)) {
                            throw QueryError.INVISIBLEFUNC_X.get(call.info(), call.name);
                        }
                    }
                    if (func.expr == null) {
                        throw QueryError.FUNCNOIMPL_X.get(func.info, new Object[]{func.name.prefixString()});
                    }
                    if (!func.updating) continue;
                    qc.updating();
                    continue;
                }
                if (!((JavaCall)call.external).updating) continue;
                qc.updating();
            }
            block2: for (Closure closure : this.closures) {
                int arity = closure.arity();
                for (StaticFunc func : this.funcs) {
                    if (arity < func.min || arity > func.arity()) continue;
                    closure.setSignature(func.funcType());
                    continue block2;
                }
            }
        }

        boolean register(StaticFunc func) {
            int nargs = func.arity();
            for (StaticFunc sf : this.funcs) {
                if (nargs < sf.min || func.min > sf.arity()) continue;
                return false;
            }
            this.funcs.add(func);
            return true;
        }

        void add(StaticFuncCall call) throws QueryException {
            this.calls.add(call);
            this.setFunc(call);
        }

        boolean setFunc(StaticFuncCall call) throws QueryException {
            int arity = call.arity();
            for (StaticFunc func : this.funcs) {
                if (arity < func.min || arity > func.arity()) continue;
                call.setFunc(func);
                return true;
            }
            return false;
        }

        boolean setJava(StaticFuncCall call, QueryContext qc) throws QueryException {
            JavaCall java = this.closures.isEmpty() ? JavaCall.get(call.name, call.exprs, qc, call.info()) : null;
            call.setExternal(java);
            return java != null;
        }

        void add(Closure closure) {
            this.closures.add(closure);
        }

        QNm qname() {
            return this.funcs.isEmpty() ? this.calls.get((int)0).name : this.funcs.get((int)0).name;
        }
    }
}

