/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.grammar;

import de.bottlecaps.markup.blitz.codepoints.Codepoint;
import de.bottlecaps.markup.blitz.grammar.Term;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.util.Arrays;
import java.util.stream.Collectors;

public class Insertion
extends Term {
    private final String value;
    private final boolean isHex;
    private int[] codepoints;
    private final int hashCode;

    public Insertion(int ... codepoints) {
        this(null, false, codepoints);
    }

    public Insertion(String value, boolean isHex) {
        int[] nArray;
        if (isHex) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = Codepoint.of(value.substring(1));
        } else {
            nArray = value.codePoints().toArray();
        }
        this(value, isHex, nArray);
    }

    private Insertion(String value, boolean isHex, int ... codepoints) {
        this.codepoints = codepoints;
        int prime = 31;
        int h = 1;
        this.hashCode = h = 31 * h + Arrays.hashCode(codepoints);
        this.value = value;
        this.isHex = isHex;
    }

    public int[] getCodepoints() {
        return this.codepoints;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public String toString() {
        if (this.isHex) {
            return "+" + this.value;
        }
        return Arrays.stream(this.codepoints).mapToObj(codepoint -> {
            if (codepoint == 39) {
                return "+''''";
            }
            if (Codepoint.isAscii(codepoint)) {
                return "+'" + (char)codepoint + "'";
            }
            return "+#" + Integer.toHexString(codepoint);
        }).collect(Collectors.joining(", ")).replace("', +'", "");
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Insertion)) {
            return false;
        }
        Insertion other = (Insertion)obj;
        return Arrays.equals(this.codepoints, other.codepoints);
    }
}

