/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import java.io.IOException;
import org.basex.build.csv.CsvOptions;
import org.basex.build.csv.CsvParserOptions;
import org.basex.core.jobs.Job;
import org.basex.io.IO;
import org.basex.io.in.NewlineInput;
import org.basex.io.in.TextInput;
import org.basex.io.parse.csv.CsvDirectConverter;
import org.basex.io.parse.csv.CsvParser;
import org.basex.io.parse.csv.CsvW3ArraysConverter;
import org.basex.io.parse.csv.CsvW3Converter;
import org.basex.io.parse.csv.CsvW3XmlConverter;
import org.basex.io.parse.csv.CsvXQueryConverter;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.util.SharedData;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public abstract class CsvConverter
extends Job {
    public static final Str COLUMNS = Str.get("columns");
    public static final Str COLUMN_INDEX = Str.get("column-index");
    public static final Str ROWS = Str.get("rows");
    public static final Str GET = Str.get("get");
    protected static final QNm Q_CSV = new QNm("csv");
    protected static final QNm Q_RECORD = new QNm("record");
    protected static final QNm Q_ENTRY = new QNm("entry");
    protected static final QNm Q_NAME = new QNm("name");
    protected final CsvParserOptions copts;
    protected final SharedData shared = new SharedData();
    protected final TokenList headers = new TokenList(1L);
    protected final boolean attributes;
    protected final boolean lax;
    protected final boolean skipEmpty;
    protected TextInput ti;
    protected int col = -1;

    public static CsvConverter get(CsvParserOptions copts) {
        return switch (copts.get(CsvOptions.FORMAT)) {
            case CsvOptions.CsvFormat.W3 -> new CsvW3Converter(copts);
            case CsvOptions.CsvFormat.W3_ARRAYS -> new CsvW3ArraysConverter(copts);
            case CsvOptions.CsvFormat.W3_XML -> new CsvW3XmlConverter(copts);
            case CsvOptions.CsvFormat.XQUERY -> new CsvXQueryConverter(copts);
            default -> new CsvDirectConverter(copts);
        };
    }

    protected CsvConverter(CsvParserOptions copts) {
        this.copts = copts;
        this.lax = copts.get(CsvOptions.LAX);
        this.attributes = copts.get(CsvOptions.FORMAT) == CsvOptions.CsvFormat.ATTRIBUTES;
        Value header = copts.get(CsvOptions.HEADER);
        boolean bl = this.skipEmpty = copts.get(CsvParserOptions.SKIP_EMPTY) != false && header != Bln.FALSE;
        if (header.seqType().type.isStringOrUntyped()) {
            TokenSet names = new TokenSet();
            try {
                for (Item columnName : header) {
                    byte[] token = columnName.string(null);
                    this.header(names.add(token) ? token : Token.EMPTY);
                }
            }
            catch (QueryException ex) {
                throw Util.notExpected(ex, new Object[0]);
            }
        }
    }

    public final Value convert(IO input) throws QueryException, IOException {
        try (NewlineInput in = new NewlineInput(input);){
            Value value = this.convert(in, input.url(), null, null);
            return value;
        }
    }

    public final Value convert(TextInput input, String uri, InputInfo ii, QueryContext qc) throws QueryException, IOException {
        this.ti = input;
        this.init(uri);
        new CsvParser(input, this.copts, this).parse(ii);
        return this.finish(ii, qc);
    }

    protected abstract void header(byte[] var1);

    protected abstract void record() throws IOException;

    protected abstract void entry(byte[] var1) throws IOException;

    protected abstract void init(String var1);

    protected abstract Value finish(InputInfo var1, QueryContext var2) throws QueryException, IOException;
}

