/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(name="StringSplit", category=BugPattern.Category.JDK, summary="String.split should never take only a single argument; it has surprising behavior", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class StringSplit
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.instanceMethod().onDescendantOf("java.lang.String").withSignature("split(java.lang.String)");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().postfixWith((Tree)Iterables.getOnlyElement(arguments), ", -1").build());
    }
}

