/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.LongSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import java.util.OptionalLong;
import javax.annotation.Nullable;

public final class OptionalLongSubject
extends Subject<OptionalLongSubject, OptionalLong> {
    private static final SubjectFactory<OptionalLongSubject, OptionalLong> FACTORY = new SubjectFactory<OptionalLongSubject, OptionalLong>(){

        public OptionalLongSubject getSubject(FailureStrategy fs, OptionalLong target) {
            return new OptionalLongSubject(fs, target);
        }
    };

    OptionalLongSubject(FailureStrategy failureStrategy, @Nullable OptionalLong subject) {
        super(failureStrategy, (Object)subject);
    }

    public void isPresent() {
        if (this.actual() == null || !((OptionalLong)this.actual()).isPresent()) {
            this.failWithoutActual("is present");
        }
    }

    public void isEmpty() {
        if (this.actual() == null || ((OptionalLong)this.actual()).isPresent()) {
            this.fail("is empty");
        }
    }

    public void hasValue(long expected) {
        if (this.actual() == null || !((OptionalLong)this.actual()).isPresent()) {
            this.fail("has value", expected);
        } else {
            long actual = ((OptionalLong)this.actual()).getAsLong();
            if (actual != expected) {
                this.fail("has value", expected);
            }
        }
    }

    public LongSubject hasValueThat() {
        if (this.actual() == null || !((OptionalLong)this.actual()).isPresent()) {
            this.failWithoutActual("is present");
            return this.ignoreCheck().that(Long.valueOf(0L));
        }
        return this.check().that(Long.valueOf(((OptionalLong)this.actual()).getAsLong()));
    }

    public static SubjectFactory<OptionalLongSubject, OptionalLong> optionalLongs() {
        return FACTORY;
    }
}

