/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.InjectingObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.strings.StringCodecs;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Optional;
import javax.annotation.Nullable;

public class PolymorphicHelper {
    private PolymorphicHelper() {
    }

    public static void serialize(Object input, CodedOutputStream codedOut, @Nullable Optional<?> dependency) throws IOException, SerializationException {
        if (input != null) {
            Class<?> clazz = input.getClass();
            try {
                Object codec = PolymorphicHelper.getCodec(clazz);
                codedOut.writeBoolNoTag(true);
                StringCodecs.asciiOptimized().serialize(clazz.getName(), codedOut);
                if (codec instanceof ObjectCodec) {
                    ((ObjectCodec)codec).serialize(input, codedOut);
                }
                if (codec instanceof InjectingObjectCodec) {
                    if (dependency == null) {
                        throw new SerializationException(clazz.getCanonicalName() + " serialize parent class lacks required dependency.");
                    }
                    ((InjectingObjectCodec)codec).serialize(dependency.orElse(null), input, codedOut);
                }
                throw new SerializationException(clazz.getCanonicalName() + ".CODEC has unexpected type " + codec.getClass().getCanonicalName());
            }
            catch (ReflectiveOperationException e) {
                throw new SerializationException(input.getClass().getName(), e);
            }
        } else {
            codedOut.writeBoolNoTag(false);
        }
    }

    public static Object deserialize(CodedInputStream codedIn, @Nullable Optional<?> dependency) throws IOException, SerializationException {
        Object deserialized = null;
        if (codedIn.readBool()) {
            String className = StringCodecs.asciiOptimized().deserialize(codedIn);
            try {
                Object codec = PolymorphicHelper.getCodec(Class.forName(className));
                if (codec instanceof ObjectCodec) {
                    return ((ObjectCodec)codec).deserialize(codedIn);
                }
                if (codec instanceof InjectingObjectCodec) {
                    if (dependency == null) {
                        throw new SerializationException(className + " deserialize parent class lacks required dependency.");
                    }
                    return ((InjectingObjectCodec)codec).deserialize(dependency.orElse(null), codedIn);
                }
                throw new SerializationException(className + ".CODEC has unexpected type " + codec.getClass().getCanonicalName());
            }
            catch (ReflectiveOperationException e) {
                throw new SerializationException(className, e);
            }
        }
        return deserialized;
    }

    private static Object getCodec(Class<?> clazz) throws NoSuchFieldException, IllegalAccessException {
        Field codecField = clazz.getDeclaredField("CODEC");
        codecField.setAccessible(true);
        return codecField.get(null);
    }
}

