/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.ImmutableListCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.strings.StringCodecs;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

public class SerializationCommonUtils {
    public static final ImmutableListCodec<String> STRING_LIST_CODEC = new ImmutableListCodec<String>(StringCodecs.asciiOptimized());

    public static <T> void serializeNullable(T obj, CodedOutputStream out, ObjectCodec<T> codec) throws IOException, SerializationException {
        if (obj == null) {
            out.writeBoolNoTag(false);
        } else {
            out.writeBoolNoTag(true);
            codec.serialize(obj, out);
        }
    }

    public static <T> T deserializeNullable(CodedInputStream in, ObjectCodec<T> codec) throws IOException, SerializationException {
        return in.readBool() ? (T)codec.deserialize(in) : null;
    }
}

