/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractSuppressWarningsMatcher
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    AbstractSuppressWarningsMatcher() {
    }

    protected abstract void processSuppressWarningsValues(List<String> var1);

    protected final Fix getSuggestedFix(AnnotationTree annotationTree) {
        ArrayList<String> values = new ArrayList<String>();
        for (ExpressionTree expressionTree : annotationTree.getArguments()) {
            AssignmentTree assignmentTree = (AssignmentTree)expressionTree;
            if (assignmentTree.getVariable().toString().equals("value")) {
                ExpressionTree expressionTree2 = assignmentTree.getExpression();
                switch (expressionTree2.getKind()) {
                    case STRING_LITERAL: {
                        values.add((String)((JCTree.JCLiteral)expressionTree2).value);
                        break;
                    }
                    case NEW_ARRAY: {
                        NewArrayTree newArrayTree = (NewArrayTree)expressionTree2;
                        for (ExpressionTree expressionTree3 : newArrayTree.getInitializers()) {
                            values.add((String)((JCTree.JCLiteral)expressionTree3).value);
                        }
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown kind: " + (Object)((Object)expressionTree2.getKind())));
                    }
                }
                this.processSuppressWarningsValues(values);
                continue;
            }
            throw new AssertionError((Object)"SuppressWarnings has an element other than value=");
        }
        if (values.isEmpty()) {
            return SuggestedFix.delete((Tree)annotationTree);
        }
        if (values.size() == 1) {
            return SuggestedFix.replace((Tree)annotationTree, (String)("@SuppressWarnings(\"" + (String)values.get(0) + "\")"));
        }
        return SuggestedFix.replace((Tree)annotationTree, (String)("@SuppressWarnings({\"" + Joiner.on((String)"\", \"").join(values) + "\"})"));
    }
}

