/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.formatstring.AutoValue_FormatStringValidation_ValidationResult;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import edu.umd.cs.findbugs.formatStringChecker.ExtraFormatArgumentsException;
import edu.umd.cs.findbugs.formatStringChecker.Formatter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayDeque;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.DuplicateFormatFlagsException;
import java.util.FormatFlagsConversionMismatchException;
import java.util.GregorianCalendar;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.UnknownFormatConversionException;
import java.util.UnknownFormatFlagsException;
import javax.annotation.Nullable;
import javax.lang.model.type.TypeKind;

public class FormatStringValidation {
    @Nullable
    public static ValidationResult validate(Collection<? extends ExpressionTree> arguments, final VisitorState state) {
        Type type;
        ArrayDeque<? extends ExpressionTree> args = new ArrayDeque<ExpressionTree>(arguments);
        String formatString = (String)ASTHelpers.constValue((Tree)((Tree)args.removeFirst()), String.class);
        if (formatString == null) {
            return null;
        }
        if (args.size() == 1 && (type = ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(args)))) instanceof Type.ArrayType && ASTHelpers.isSameType((Type)((Type.ArrayType)type).elemtype, (Type)state.getSymtab().objectType, (VisitorState)state)) {
            return null;
        }
        Iterable instances = Iterables.transform(args, (Function)new Function<ExpressionTree, Object>(){

            public Object apply(ExpressionTree input) {
                try {
                    return FormatStringValidation.getInstance(input, state);
                }
                catch (Throwable t) {
                    return null;
                }
            }
        });
        return FormatStringValidation.validate(formatString, instances);
    }

    private static Object getInstance(Tree tree, VisitorState state) {
        Object value = ASTHelpers.constValue((Tree)tree);
        if (value != null) {
            return value;
        }
        Type type = ASTHelpers.getType((Tree)tree);
        Types types = state.getTypes();
        if (type.getKind() == TypeKind.NULL) {
            return null;
        }
        if ((type = types.unboxedTypeOrType(types.erasure(type))).isPrimitive()) {
            switch (type.getKind()) {
                case BOOLEAN: {
                    return false;
                }
                case BYTE: {
                    return (byte)1;
                }
                case SHORT: {
                    return (short)2;
                }
                case INT: {
                    return 3;
                }
                case LONG: {
                    return 4L;
                }
                case CHAR: {
                    return Character.valueOf('c');
                }
                case FLOAT: {
                    return Float.valueOf(5.0f);
                }
                case DOUBLE: {
                    return 6.0;
                }
                case VOID: 
                case NONE: 
                case NULL: 
                case ERROR: {
                    return null;
                }
                case ARRAY: {
                    return new Object[0];
                }
            }
        }
        if (types.isSubtype(type, state.getSymtab().stringType)) {
            return String.valueOf("string");
        }
        if (types.isSubtype(type, state.getTypeFromString(BigDecimal.class.getName()))) {
            return BigDecimal.valueOf(42.0);
        }
        if (types.isSubtype(type, state.getTypeFromString(BigInteger.class.getName()))) {
            return BigInteger.valueOf(43L);
        }
        if (types.isSubtype(type, state.getTypeFromString(Date.class.getName()))) {
            return new Date();
        }
        if (types.isSubtype(type, state.getTypeFromString(Calendar.class.getName()))) {
            return new GregorianCalendar();
        }
        if (types.isSubtype(type, state.getTypeFromString(TemporalAccessor.class.getName()))) {
            return LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault());
        }
        return new Object();
    }

    private static ValidationResult validate(String formatString, Iterable<Object> arguments) {
        try {
            String string = String.format(formatString, Iterables.toArray(arguments, Object.class));
        }
        catch (DuplicateFormatFlagsException e) {
            return ValidationResult.create(e, String.format("duplicate format flags: %s", e.getFlags()));
        }
        catch (FormatFlagsConversionMismatchException e) {
            return ValidationResult.create(e, String.format("format specifier '%%%s' is not compatible with the given flag(s): %s", Character.valueOf(e.getConversion()), e.getFlags()));
        }
        catch (IllegalFormatCodePointException e) {
            return ValidationResult.create(e, String.format("invalid Unicode code point: %x", e.getCodePoint()));
        }
        catch (IllegalFormatConversionException e) {
            return ValidationResult.create(e, String.format("illegal format conversion: '%s' cannot be formatted using '%%%s'", e.getArgumentClass().getName(), Character.valueOf(e.getConversion())));
        }
        catch (IllegalFormatFlagsException e) {
            return ValidationResult.create(e, String.format("illegal format flags: %s", e.getFlags()));
        }
        catch (IllegalFormatPrecisionException e) {
            return ValidationResult.create(e, String.format("illegal format precision: %d", e.getPrecision()));
        }
        catch (IllegalFormatWidthException e) {
            return ValidationResult.create(e, String.format("illegal format width: %s", e.getWidth()));
        }
        catch (MissingFormatArgumentException e) {
            return ValidationResult.create(e, String.format("missing argument for format specifier '%s'", e.getFormatSpecifier()));
        }
        catch (MissingFormatWidthException e) {
            return ValidationResult.create(e, String.format("missing format width: %s", e.getFormatSpecifier()));
        }
        catch (UnknownFormatConversionException e) {
            return ValidationResult.create(e, FormatStringValidation.unknownFormatConversion(e.getConversion()));
        }
        catch (UnknownFormatFlagsException e) {
            return ValidationResult.create(e, String.format("unknown format flag(s): %s", e.getFlags()));
        }
        try {
            String[] argDescriptors = Collections.nCopies(Iterables.size(arguments), "Ljava/lang/Object;").toArray(new String[0]);
            Formatter.check((String)formatString, (String[])argDescriptors);
        }
        catch (ExtraFormatArgumentsException e) {
            return ValidationResult.create((Exception)((Object)e), String.format("extra format arguments: used %d, provided %d", e.used, e.provided));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String unknownFormatConversion(String conversion) {
        if (conversion.equals("l")) {
            return "%l is not a valid format specifier; use %d for all integral types and %f for all floating point types";
        }
        return String.format("unknown format conversion: '%s'", conversion);
    }

    @AutoValue
    public static abstract class ValidationResult {
        @Nullable
        public abstract Exception exception();

        public abstract String message();

        public static ValidationResult create(@Nullable Exception exception, String message) {
            return new AutoValue_FormatStringValidation_ValidationResult(exception, message);
        }
    }
}

