/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.util;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.BufferBuilder;
import com.hazelcast.util.collection.Long2ObjectHashMap;
import java.nio.ByteBuffer;

public class ClientMessageBuilder {
    private final Long2ObjectHashMap<BufferBuilder> builderBySessionIdMap = new Long2ObjectHashMap();
    private final MessageHandler delegate;
    private ClientMessage message = ClientMessage.create();

    public ClientMessageBuilder(MessageHandler delegate) {
        this.delegate = delegate;
    }

    public void onData(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            BufferBuilder builder;
            boolean complete = this.message.readFrom(buffer);
            if (!complete) {
                return;
            }
            if (this.message.isFlagSet((short)192)) {
                this.handleMessage(this.message);
                this.message = ClientMessage.create();
                continue;
            }
            if (this.message.isFlagSet((short)128)) {
                builder = new BufferBuilder();
                this.builderBySessionIdMap.put(this.message.getCorrelationId(), builder);
                builder.append(this.message.buffer(), 0, this.message.getFrameLength());
            } else {
                builder = this.builderBySessionIdMap.get(this.message.getCorrelationId());
                if (builder.position() == 0) {
                    throw new IllegalStateException();
                }
                builder.append(this.message.buffer(), this.message.getDataOffset(), this.message.getFrameLength() - this.message.getDataOffset());
                if (this.message.isFlagSet((short)64)) {
                    int msgLength = builder.position();
                    ClientMessage cm = ClientMessage.createForDecode(builder.buffer(), 0);
                    cm.setFrameLength(msgLength);
                    this.handleMessage(cm);
                    this.builderBySessionIdMap.remove(this.message.getCorrelationId());
                }
            }
            this.message = ClientMessage.create();
        }
    }

    private void handleMessage(ClientMessage message) {
        message.index(message.getDataOffset());
        this.delegate.handleMessage(message);
    }

    public static interface MessageHandler {
        public void handleMessage(ClientMessage var1);
    }
}

