/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.semaphore;

import com.hazelcast.concurrent.semaphore.SemaphoreService;
import com.hazelcast.concurrent.semaphore.operations.AcquireOperation;
import com.hazelcast.concurrent.semaphore.operations.AvailableOperation;
import com.hazelcast.concurrent.semaphore.operations.DrainOperation;
import com.hazelcast.concurrent.semaphore.operations.InitOperation;
import com.hazelcast.concurrent.semaphore.operations.ReduceOperation;
import com.hazelcast.concurrent.semaphore.operations.ReleaseOperation;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.TimeUnit;

public class SemaphoreProxy
extends AbstractDistributedObject<SemaphoreService>
implements ISemaphore {
    private final String name;
    private final int partitionId;

    public SemaphoreProxy(String name, SemaphoreService service, NodeEngine nodeEngine) {
        super(nodeEngine, service);
        this.name = name;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean init(int permits) {
        Preconditions.checkNotNegative(permits, "permits can't be negative");
        InitOperation operation = new InitOperation(this.name, permits);
        InternalCompletableFuture future = this.invoke(operation);
        return (Boolean)future.getSafely();
    }

    @Override
    public void acquire() throws InterruptedException {
        this.acquire(1);
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        Preconditions.checkNotNegative(permits, "permits can't be negative");
        try {
            AcquireOperation operation = new AcquireOperation(this.name, permits, -1L);
            InternalCompletableFuture future = this.invoke(operation);
            future.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowInterrupted(t);
        }
    }

    @Override
    public int availablePermits() {
        AvailableOperation operation = new AvailableOperation(this.name);
        InternalCompletableFuture future = this.invoke(operation);
        return (Integer)future.getSafely();
    }

    @Override
    public int drainPermits() {
        DrainOperation operation = new DrainOperation(this.name);
        InternalCompletableFuture future = this.invoke(operation);
        return (Integer)future.getSafely();
    }

    @Override
    public void reducePermits(int reduction) {
        Preconditions.checkNotNegative(reduction, "reduction can't be negative");
        ReduceOperation operation = new ReduceOperation(this.name, reduction);
        InternalCompletableFuture future = this.invoke(operation);
        future.getSafely();
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        Preconditions.checkNotNegative(permits, "permits can't be negative");
        ReleaseOperation operation = new ReleaseOperation(this.name, permits);
        InternalCompletableFuture future = this.invoke(operation);
        future.getSafely();
    }

    @Override
    public boolean tryAcquire() {
        try {
            return this.tryAcquire(1, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean tryAcquire(int permits) {
        try {
            return this.tryAcquire(permits, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, timeout, unit);
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNegative(permits, "permits can't be negative");
        try {
            AcquireOperation operation = new AcquireOperation(this.name, permits, unit.toMillis(timeout));
            InternalCompletableFuture future = this.invoke(operation);
            return (Boolean)future.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowInterrupted(t);
        }
    }

    private <T> InternalCompletableFuture<T> invoke(Operation operation) {
        NodeEngine nodeEngine = this.getNodeEngine();
        OperationService operationService = nodeEngine.getOperationService();
        return operationService.invokeOnPartition("hz:impl:semaphoreService", operation, this.partitionId);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:semaphoreService";
    }

    @Override
    public String toString() {
        return "ISemaphore{name='" + this.name + '\'' + '}';
    }
}

