/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractListMultimapTester;
import java.util.List;
import java.util.Map;

@GwtCompatible
public class ListMultimapPutTester<K, V>
extends AbstractListMultimapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAddsValueAtEnd() {
        for (Object key : this.sampleKeys()) {
            for (Object value : this.sampleValues()) {
                this.resetContainer();
                List values = ((ListMultimap)this.multimap()).get(key);
                List expectedValues = Helpers.copyToList(values);
                ListMultimapPutTester.assertTrue((boolean)((ListMultimap)this.multimap()).put(key, value));
                expectedValues.add(value);
                this.assertGet(key, expectedValues);
                ListMultimapPutTester.assertEquals(value, values.get(values.size() - 1));
            }
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutDuplicateValue() {
        List<Map.Entry> entries = Helpers.copyToList(((ListMultimap)this.multimap()).entries());
        for (Map.Entry entry : entries) {
            this.resetContainer();
            Object k = entry.getKey();
            Object v = entry.getValue();
            List values = ((ListMultimap)this.multimap()).get(k);
            List expectedValues = Helpers.copyToList(values);
            ListMultimapPutTester.assertTrue((boolean)((ListMultimap)this.multimap()).put(k, v));
            expectedValues.add(v);
            this.assertGet(k, expectedValues);
            ListMultimapPutTester.assertEquals(v, values.get(values.size() - 1));
        }
    }
}

