/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.util;

import com.google.protobuf.Descriptors;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.util.FieldMaskUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

final class FieldMaskTree {
    private static final Logger logger = Logger.getLogger(FieldMaskTree.class.getName());
    private static final String FIELD_PATH_SEPARATOR_REGEX = "\\.";
    private final Node root = new Node();

    FieldMaskTree() {
    }

    FieldMaskTree(FieldMask fieldMask) {
        this.mergeFromFieldMask(fieldMask);
    }

    public String toString() {
        return FieldMaskUtil.toString(this.toFieldMask());
    }

    FieldMaskTree addFieldPath(String string) {
        String[] stringArray = string.split(FIELD_PATH_SEPARATOR_REGEX);
        if (stringArray.length == 0) {
            return this;
        }
        Node node = this.root;
        boolean bl = false;
        for (String string2 : stringArray) {
            if (!bl && node != this.root && node.children.isEmpty()) {
                return this;
            }
            if (node.children.containsKey(string2)) {
                node = (Node)node.children.get(string2);
                continue;
            }
            bl = true;
            Node node2 = new Node();
            node.children.put(string2, node2);
            node = node2;
        }
        node.children.clear();
        return this;
    }

    FieldMaskTree mergeFromFieldMask(FieldMask fieldMask) {
        for (String string : fieldMask.getPathsList()) {
            this.addFieldPath(string);
        }
        return this;
    }

    FieldMask toFieldMask() {
        if (this.root.children.isEmpty()) {
            return FieldMask.getDefaultInstance();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        this.getFieldPaths(this.root, "", arrayList);
        return FieldMask.newBuilder().addAllPaths(arrayList).build();
    }

    private void getFieldPaths(Node node, String string, List<String> list) {
        if (node.children.isEmpty()) {
            list.add(string);
            return;
        }
        for (Map.Entry<String, Node> entry : node.children.entrySet()) {
            String string2 = string.isEmpty() ? entry.getKey() : string + "." + entry.getKey();
            this.getFieldPaths(entry.getValue(), string2, list);
        }
    }

    void intersectFieldPath(String string, FieldMaskTree fieldMaskTree) {
        if (this.root.children.isEmpty()) {
            return;
        }
        String[] stringArray = string.split(FIELD_PATH_SEPARATOR_REGEX);
        if (stringArray.length == 0) {
            return;
        }
        Node node = this.root;
        for (String string2 : stringArray) {
            if (node != this.root && node.children.isEmpty()) {
                fieldMaskTree.addFieldPath(string);
                return;
            }
            if (!node.children.containsKey(string2)) {
                return;
            }
            node = (Node)node.children.get(string2);
        }
        ArrayList arrayList = new ArrayList();
        this.getFieldPaths(node, string, arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            fieldMaskTree.addFieldPath(string3);
        }
    }

    void merge(Message message, Message.Builder builder, FieldMaskUtil.MergeOptions mergeOptions) {
        if (message.getDescriptorForType() != builder.getDescriptorForType()) {
            throw new IllegalArgumentException("Cannot merge messages of different types.");
        }
        if (this.root.children.isEmpty()) {
            return;
        }
        this.merge(this.root, "", message, builder, mergeOptions);
    }

    private void merge(Node node, String string, Message message, Message.Builder builder, FieldMaskUtil.MergeOptions mergeOptions) {
        if (message.getDescriptorForType() != builder.getDescriptorForType()) {
            throw new IllegalArgumentException(String.format("source (%s) and destination (%s) descriptor must be equal", message.getDescriptorForType(), builder.getDescriptorForType()));
        }
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        for (Map.Entry<String, Node> entry : node.children.entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(entry.getKey());
            if (fieldDescriptor == null) {
                logger.warning("Cannot find field \"" + entry.getKey() + "\" in message type " + descriptor.getFullName());
                continue;
            }
            if (!entry.getValue().children.isEmpty()) {
                if (fieldDescriptor.isRepeated() || fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    logger.warning("Field \"" + fieldDescriptor.getFullName() + "\" is not a singluar message field and cannot have sub-fields.");
                    continue;
                }
                String string2 = string.isEmpty() ? entry.getKey() : string + "." + entry.getKey();
                this.merge(entry.getValue(), string2, (Message)message.getField(fieldDescriptor), builder.getFieldBuilder(fieldDescriptor), mergeOptions);
                continue;
            }
            if (fieldDescriptor.isRepeated()) {
                if (mergeOptions.replaceRepeatedFields()) {
                    builder.setField(fieldDescriptor, message.getField(fieldDescriptor));
                    continue;
                }
                for (Object e : (List)message.getField(fieldDescriptor)) {
                    builder.addRepeatedField(fieldDescriptor, e);
                }
                continue;
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (mergeOptions.replaceMessageFields()) {
                    if (!message.hasField(fieldDescriptor)) {
                        builder.clearField(fieldDescriptor);
                        continue;
                    }
                    builder.setField(fieldDescriptor, message.getField(fieldDescriptor));
                    continue;
                }
                if (!message.hasField(fieldDescriptor)) continue;
                builder.getFieldBuilder(fieldDescriptor).mergeFrom((Message)message.getField(fieldDescriptor));
                continue;
            }
            if (message.hasField(fieldDescriptor) || !mergeOptions.replacePrimitiveFields()) {
                builder.setField(fieldDescriptor, message.getField(fieldDescriptor));
                continue;
            }
            builder.clearField(fieldDescriptor);
        }
    }

    private static final class Node {
        final SortedMap<String, Node> children = new TreeMap<String, Node>();

        private Node() {
        }
    }
}

