/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.grpc.metrics;

import com.google.common.annotations.VisibleForTesting;
import io.opencensus.common.Duration;
import io.opencensus.contrib.grpc.metrics.RpcMeasureConstants;
import io.opencensus.stats.Aggregation;
import io.opencensus.stats.BucketBoundaries;
import io.opencensus.stats.Measure;
import io.opencensus.stats.View;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class RpcViewConstants {
    @VisibleForTesting
    static final List<Double> RPC_BYTES_BUCKET_BOUNDARIES = Collections.unmodifiableList(Arrays.asList(0.0, 1024.0, 2048.0, 4096.0, 16384.0, 65536.0, 262144.0, 1048576.0, 4194304.0, 1.6777216E7, 6.7108864E7, 2.68435456E8, 1.073741824E9, 4.294967296E9));
    @VisibleForTesting
    static final List<Double> RPC_MILLIS_BUCKET_BOUNDARIES = Collections.unmodifiableList(Arrays.asList(0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0, 13.0, 16.0, 20.0, 25.0, 30.0, 40.0, 50.0, 65.0, 80.0, 100.0, 130.0, 160.0, 200.0, 250.0, 300.0, 400.0, 500.0, 650.0, 800.0, 1000.0, 2000.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0));
    @VisibleForTesting
    static final List<Double> RPC_COUNT_BUCKET_BOUNDARIES = Collections.unmodifiableList(Arrays.asList(0.0, 1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0, 256.0, 512.0, 1024.0, 2048.0, 4096.0, 8192.0, 16384.0, 32768.0, 65536.0));
    @VisibleForTesting
    static final Aggregation MEAN = Aggregation.Mean.create();
    @VisibleForTesting
    static final Aggregation AGGREGATION_WITH_BYTES_HISTOGRAM = Aggregation.Distribution.create((BucketBoundaries)BucketBoundaries.create(RPC_BYTES_BUCKET_BOUNDARIES));
    @VisibleForTesting
    static final Aggregation AGGREGATION_WITH_MILLIS_HISTOGRAM = Aggregation.Distribution.create((BucketBoundaries)BucketBoundaries.create(RPC_MILLIS_BUCKET_BOUNDARIES));
    @VisibleForTesting
    static final Aggregation AGGREGATION_WITH_COUNT_HISTOGRAM = Aggregation.Distribution.create((BucketBoundaries)BucketBoundaries.create(RPC_COUNT_BUCKET_BOUNDARIES));
    @VisibleForTesting
    static final Duration MINUTE = Duration.create((long)60L, (int)0);
    @VisibleForTesting
    static final Duration HOUR = Duration.create((long)3600L, (int)0);
    @VisibleForTesting
    static final View.AggregationWindow CUMULATIVE = View.AggregationWindow.Cumulative.create();
    @VisibleForTesting
    static final View.AggregationWindow INTERVAL_MINUTE = View.AggregationWindow.Interval.create((Duration)MINUTE);
    @VisibleForTesting
    static final View.AggregationWindow INTERVAL_HOUR = View.AggregationWindow.Interval.create((Duration)HOUR);
    public static final View RPC_CLIENT_ERROR_COUNT_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/error_count/cumulative"), (String)"RPC Errors", (Measure)RpcMeasureConstants.RPC_CLIENT_ERROR_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_STATUS, RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_CLIENT_ROUNDTRIP_LATENCY_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/roundtrip_latency/cumulative"), (String)"Latency in msecs", (Measure)RpcMeasureConstants.RPC_CLIENT_ROUNDTRIP_LATENCY, (Aggregation)AGGREGATION_WITH_MILLIS_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_CLIENT_SERVER_ELAPSED_TIME_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/server_elapsed_time/cumulative"), (String)"Server elapsed time in msecs", (Measure)RpcMeasureConstants.RPC_CLIENT_SERVER_ELAPSED_TIME, (Aggregation)AGGREGATION_WITH_MILLIS_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_CLIENT_REQUEST_BYTES_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/request_bytes/cumulative"), (String)"Request bytes", (Measure)RpcMeasureConstants.RPC_CLIENT_REQUEST_BYTES, (Aggregation)AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_CLIENT_RESPONSE_BYTES_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/response_bytes/cumulative"), (String)"Response bytes", (Measure)RpcMeasureConstants.RPC_CLIENT_RESPONSE_BYTES, (Aggregation)AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/uncompressed_request_bytes/cumulative"), (String)"Uncompressed Request bytes", (Measure)RpcMeasureConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES, (Aggregation)AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/uncompressed_response_bytes/cumulative"), (String)"Uncompressed Response bytes", (Measure)RpcMeasureConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES, (Aggregation)AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_CLIENT_REQUEST_COUNT_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/request_count/cumulative"), (String)"Count of request messages per client RPC", (Measure)RpcMeasureConstants.RPC_CLIENT_REQUEST_COUNT, (Aggregation)AGGREGATION_WITH_COUNT_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_CLIENT_RESPONSE_COUNT_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/response_count/cumulative"), (String)"Count of response messages per client RPC", (Measure)RpcMeasureConstants.RPC_CLIENT_RESPONSE_COUNT, (Aggregation)AGGREGATION_WITH_COUNT_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_SERVER_ERROR_COUNT_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/error_count/cumulative"), (String)"RPC Errors", (Measure)RpcMeasureConstants.RPC_SERVER_ERROR_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_STATUS, RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_SERVER_SERVER_LATENCY_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/server_latency/cumulative"), (String)"Latency in msecs", (Measure)RpcMeasureConstants.RPC_SERVER_SERVER_LATENCY, (Aggregation)AGGREGATION_WITH_MILLIS_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_SERVER_SERVER_ELAPSED_TIME_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/elapsed_time/cumulative"), (String)"Server elapsed time in msecs", (Measure)RpcMeasureConstants.RPC_SERVER_SERVER_ELAPSED_TIME, (Aggregation)AGGREGATION_WITH_MILLIS_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_SERVER_REQUEST_BYTES_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/request_bytes/cumulative"), (String)"Request bytes", (Measure)RpcMeasureConstants.RPC_SERVER_REQUEST_BYTES, (Aggregation)AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_SERVER_RESPONSE_BYTES_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/response_bytes/cumulative"), (String)"Response bytes", (Measure)RpcMeasureConstants.RPC_SERVER_RESPONSE_BYTES, (Aggregation)AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/uncompressed_request_bytes/cumulative"), (String)"Uncompressed Request bytes", (Measure)RpcMeasureConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES, (Aggregation)AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/uncompressed_response_bytes/cumulative"), (String)"Uncompressed Response bytes", (Measure)RpcMeasureConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES, (Aggregation)AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_SERVER_REQUEST_COUNT_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/request_count/cumulative"), (String)"Count of request messages per server RPC", (Measure)RpcMeasureConstants.RPC_SERVER_REQUEST_COUNT, (Aggregation)AGGREGATION_WITH_COUNT_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_SERVER_RESPONSE_COUNT_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/response_count/cumulative"), (String)"Count of response messages per server RPC", (Measure)RpcMeasureConstants.RPC_SERVER_RESPONSE_COUNT, (Aggregation)AGGREGATION_WITH_COUNT_HISTOGRAM, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)CUMULATIVE);
    public static final View RPC_CLIENT_ROUNDTRIP_LATENCY_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/roundtrip_latency/minute"), (String)"Minute stats for latency in msecs", (Measure)RpcMeasureConstants.RPC_CLIENT_ROUNDTRIP_LATENCY, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_CLIENT_REQUEST_BYTES_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/request_bytes/minute"), (String)"Minute stats for request size in bytes", (Measure)RpcMeasureConstants.RPC_CLIENT_REQUEST_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_CLIENT_RESPONSE_BYTES_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/response_bytes/minute"), (String)"Minute stats for response size in bytes", (Measure)RpcMeasureConstants.RPC_CLIENT_RESPONSE_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_CLIENT_ERROR_COUNT_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/error_count/minute"), (String)"Minute stats for rpc errors", (Measure)RpcMeasureConstants.RPC_CLIENT_ERROR_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/uncompressed_request_bytes/minute"), (String)"Minute stats for uncompressed request size in bytes", (Measure)RpcMeasureConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/uncompressed_response_bytes/minute"), (String)"Minute stats for uncompressed response size in bytes", (Measure)RpcMeasureConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_CLIENT_SERVER_ELAPSED_TIME_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/server_elapsed_time/minute"), (String)"Minute stats for server elapsed time in msecs", (Measure)RpcMeasureConstants.RPC_CLIENT_SERVER_ELAPSED_TIME, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_CLIENT_STARTED_COUNT_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/started_count/minute"), (String)"Minute stats on the number of client RPCs started", (Measure)RpcMeasureConstants.RPC_CLIENT_STARTED_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_CLIENT_FINISHED_COUNT_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/finished_count/minute"), (String)"Minute stats on the number of client RPCs finished", (Measure)RpcMeasureConstants.RPC_CLIENT_FINISHED_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_CLIENT_REQUEST_COUNT_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/request_count/minute"), (String)"Minute stats on the count of request messages per client RPC", (Measure)RpcMeasureConstants.RPC_CLIENT_REQUEST_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_CLIENT_RESPONSE_COUNT_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/response_count/minute"), (String)"Minute stats on the count of response messages per client RPC", (Measure)RpcMeasureConstants.RPC_CLIENT_RESPONSE_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_CLIENT_ROUNDTRIP_LATENCY_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/roundtrip_latency/hour"), (String)"Hour stats for latency in msecs", (Measure)RpcMeasureConstants.RPC_CLIENT_ROUNDTRIP_LATENCY, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_CLIENT_REQUEST_BYTES_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/request_bytes/hour"), (String)"Hour stats for request size in bytes", (Measure)RpcMeasureConstants.RPC_CLIENT_REQUEST_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_CLIENT_RESPONSE_BYTES_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/response_bytes/hour"), (String)"Hour stats for response size in bytes", (Measure)RpcMeasureConstants.RPC_CLIENT_RESPONSE_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_CLIENT_ERROR_COUNT_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/error_count/hour"), (String)"Hour stats for rpc errors", (Measure)RpcMeasureConstants.RPC_CLIENT_ERROR_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/uncompressed_request_bytes/hour"), (String)"Hour stats for uncompressed request size in bytes", (Measure)RpcMeasureConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/uncompressed_response_bytes/hour"), (String)"Hour stats for uncompressed response size in bytes", (Measure)RpcMeasureConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_CLIENT_SERVER_ELAPSED_TIME_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/server_elapsed_time/hour"), (String)"Hour stats for server elapsed time in msecs", (Measure)RpcMeasureConstants.RPC_CLIENT_SERVER_ELAPSED_TIME, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_CLIENT_STARTED_COUNT_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/started_count/hour"), (String)"Hour stats on the number of client RPCs started", (Measure)RpcMeasureConstants.RPC_CLIENT_STARTED_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_CLIENT_FINISHED_COUNT_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/finished_count/hour"), (String)"Hour stats on the number of client RPCs finished", (Measure)RpcMeasureConstants.RPC_CLIENT_FINISHED_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_CLIENT_REQUEST_COUNT_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/request_count/hour"), (String)"Hour stats on the count of request messages per client RPC", (Measure)RpcMeasureConstants.RPC_CLIENT_REQUEST_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_CLIENT_RESPONSE_COUNT_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/response_count/hour"), (String)"Hour stats on the count of response messages per client RPC", (Measure)RpcMeasureConstants.RPC_CLIENT_RESPONSE_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_SERVER_SERVER_LATENCY_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/server_latency/minute"), (String)"Minute stats for server latency in msecs", (Measure)RpcMeasureConstants.RPC_SERVER_SERVER_LATENCY, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_SERVER_REQUEST_BYTES_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/request_bytes/minute"), (String)"Minute stats for request size in bytes", (Measure)RpcMeasureConstants.RPC_SERVER_REQUEST_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_SERVER_RESPONSE_BYTES_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/response_bytes/minute"), (String)"Minute stats for response size in bytes", (Measure)RpcMeasureConstants.RPC_SERVER_RESPONSE_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_SERVER_ERROR_COUNT_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/error_count/minute"), (String)"Minute stats for rpc errors", (Measure)RpcMeasureConstants.RPC_SERVER_ERROR_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/uncompressed_request_bytes/minute"), (String)"Minute stats for uncompressed request size in bytes", (Measure)RpcMeasureConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/uncompressed_response_bytes/minute"), (String)"Minute stats for uncompressed response size in bytes", (Measure)RpcMeasureConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_SERVER_SERVER_ELAPSED_TIME_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/server_elapsed_time/minute"), (String)"Minute stats for server elapsed time in msecs", (Measure)RpcMeasureConstants.RPC_SERVER_SERVER_ELAPSED_TIME, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_SERVER_STARTED_COUNT_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/started_count/minute"), (String)"Minute stats on the number of server RPCs started", (Measure)RpcMeasureConstants.RPC_SERVER_STARTED_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_SERVER_FINISHED_COUNT_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/finished_count/minute"), (String)"Minute stats on the number of server RPCs finished", (Measure)RpcMeasureConstants.RPC_SERVER_FINISHED_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_SERVER_REQUEST_COUNT_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/request_count/minute"), (String)"Minute stats on the count of request messages per server RPC", (Measure)RpcMeasureConstants.RPC_SERVER_REQUEST_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_SERVER_RESPONSE_COUNT_MINUTE_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/response_count/minute"), (String)"Minute stats on the count of response messages per server RPC", (Measure)RpcMeasureConstants.RPC_SERVER_RESPONSE_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_MINUTE);
    public static final View RPC_SERVER_SERVER_LATENCY_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/server_latency/hour"), (String)"Hour stats for server latency in msecs", (Measure)RpcMeasureConstants.RPC_SERVER_SERVER_LATENCY, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_SERVER_REQUEST_BYTES_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/request_bytes/hour"), (String)"Hour stats for request size in bytes", (Measure)RpcMeasureConstants.RPC_SERVER_REQUEST_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_SERVER_RESPONSE_BYTES_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/response_bytes/hour"), (String)"Hour stats for response size in bytes", (Measure)RpcMeasureConstants.RPC_SERVER_RESPONSE_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_SERVER_ERROR_COUNT_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/error_count/hour"), (String)"Hour stats for rpc errors", (Measure)RpcMeasureConstants.RPC_SERVER_ERROR_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/uncompressed_request_bytes/hour"), (String)"Hour stats for uncompressed request size in bytes", (Measure)RpcMeasureConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/uncompressed_response_bytes/hour"), (String)"Hour stats for uncompressed response size in bytes", (Measure)RpcMeasureConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_SERVER_SERVER_ELAPSED_TIME_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/server_elapsed_time/hour"), (String)"Hour stats for server elapsed time in msecs", (Measure)RpcMeasureConstants.RPC_SERVER_SERVER_ELAPSED_TIME, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_SERVER_STARTED_COUNT_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/started_count/hour"), (String)"Hour stats on the number of server RPCs started", (Measure)RpcMeasureConstants.RPC_SERVER_STARTED_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_SERVER_FINISHED_COUNT_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/finished_count/hour"), (String)"Hour stats on the number of server RPCs finished", (Measure)RpcMeasureConstants.RPC_SERVER_FINISHED_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_SERVER_REQUEST_COUNT_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/request_count/hour"), (String)"Hour stats on the count of request messages per server RPC", (Measure)RpcMeasureConstants.RPC_SERVER_REQUEST_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);
    public static final View RPC_SERVER_RESPONSE_COUNT_HOUR_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/response_count/hour"), (String)"Hour stats on the count of response messages per server RPC", (Measure)RpcMeasureConstants.RPC_SERVER_RESPONSE_COUNT, (Aggregation)MEAN, Arrays.asList(RpcMeasureConstants.RPC_METHOD), (View.AggregationWindow)INTERVAL_HOUR);

    RpcViewConstants() {
        throw new AssertionError();
    }
}

