/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepoXsdUtil {
    public static final String NODE_IMPORT = "import";
    public static final String NODE_INCLUDE = "include";
    public static final String ATTR_SCHEMA_LOCATION = "schemaLocation";

    public static StreamSource[] getXsdStream(String rootElement, int version) {
        String filename = String.format("%1$s-%2$02d.xsd", rootElement, version);
        final ArrayList streams = Lists.newArrayList();
        InputStream stream = null;
        try {
            stream = RepoXsdUtil.class.getResourceAsStream(filename);
            if (stream == null) {
                filename = String.format("%1$s-%2$d.xsd", rootElement, version);
                stream = RepoXsdUtil.class.getResourceAsStream(filename);
            }
            if (stream == null) {
                filename = String.format("-%1$s-%2$02d.xsd", rootElement, version);
                stream = RepoXsdUtil.class.getResourceAsStream(filename);
            }
            SAXParserFactory.newInstance().newSAXParser().parse(stream, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    if ((name = name.substring(name.indexOf(58) + 1)).equals(RepoXsdUtil.NODE_IMPORT) || name.equals(RepoXsdUtil.NODE_INCLUDE)) {
                        String importFile = attributes.getValue(RepoXsdUtil.ATTR_SCHEMA_LOCATION);
                        streams.add(new StreamSource(RepoXsdUtil.class.getResourceAsStream(importFile)));
                    }
                }
            });
            streams.add(new StreamSource(RepoXsdUtil.class.getResourceAsStream(filename)));
        }
        catch (Exception e) {
            return null;
        }
        return streams.toArray(new StreamSource[streams.size()]);
    }
}

