/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_UngroupedOverloads_MemberWithIndex;
import com.google.errorprone.bugpatterns.AutoValue_UngroupedOverloads_OverloadKey;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Name;

@BugPattern(name="UngroupedOverloads", summary="Constructors and methods with the same name should appear sequentially with no other code in between. Please re-order or re-name methods.", generateExamplesFromTestCases=false, category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s3.4.2.1-overloads-never-split")
public class UngroupedOverloads
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private final Boolean showFindingOnFirstOverloadOnly;

    public UngroupedOverloads(ErrorProneFlags flags) {
        this.showFindingOnFirstOverloadOnly = flags.getBoolean("UngroupedOverloads:FindingsOnFirstOverload").orElse(false);
    }

    public Description matchClass(ClassTree classTree, VisitorState state) {
        LinkedHashMultimap methods = (LinkedHashMultimap)Streams.zip(Stream.iterate(0, i -> i + 1), classTree.getMembers().stream(), MemberWithIndex::create).filter(m -> m.tree() instanceof MethodTree).collect(Multimaps.toMultimap(m -> OverloadKey.create((MethodTree)m.tree()), x -> x, LinkedHashMultimap::create));
        methods.asMap().forEach((key, overloads) -> this.checkOverloads(state, classTree.getMembers(), key.name(), (ImmutableList<MemberWithIndex>)ImmutableList.copyOf((Collection)overloads)));
        return Description.NO_MATCH;
    }

    private void checkOverloads(VisitorState state, List<? extends Tree> members, Name name, ImmutableList<MemberWithIndex> overloads) {
        if (overloads.size() <= 1) {
            return;
        }
        MemberWithIndex first = (MemberWithIndex)overloads.iterator().next();
        int prev = -1;
        int group = 0;
        LinkedHashMap<MemberWithIndex, Integer> groups = new LinkedHashMap<MemberWithIndex, Integer>();
        for (MemberWithIndex overload : overloads) {
            if (prev != -1 && prev != overload.index() - 1) {
                ++group;
            }
            groups.put(overload, group);
            prev = overload.index();
        }
        if (group == 0) {
            return;
        }
        if (overloads.stream().anyMatch(m -> this.isSuppressed(m.tree()))) {
            return;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        StringBuilder sb = new StringBuilder("\n");
        overloads.stream().filter(o -> o != first).forEach(o -> {
            int start = state.getEndPosition((Tree)members.get(o.index() - 1));
            int end = state.getEndPosition(o.tree());
            sb.append(state.getSourceCode(), start, end).append('\n');
            fixBuilder.replace(start, end, "");
        });
        fixBuilder.postfixWith(first.tree(), sb.toString());
        SuggestedFix fix = fixBuilder.build();
        LineMap lineMap = state.getPath().getCompilationUnit().getLineMap();
        overloads.stream().limit(this.showFindingOnFirstOverloadOnly != false ? 1L : Long.MAX_VALUE).forEach(o -> state.reportMatch(this.buildDescription(o.tree()).addFix((Fix)fix).setMessage(UngroupedOverloads.createMessage(name, overloads, groups, lineMap, o)).build()));
    }

    private static String createMessage(Name name, ImmutableList<MemberWithIndex> overloads, Map<MemberWithIndex, Integer> groups, LineMap lineMap, MemberWithIndex current) {
        String ungroupedLines = overloads.stream().filter(o -> !((Integer)groups.get(o)).equals(groups.get(current))).map(t -> lineMap.getLineNumber(((JCTree)t.tree()).getStartPosition())).map(String::valueOf).collect(Collectors.joining(", "));
        return String.format("Overloads of '%s' are not grouped together; found ungrouped overloads on line(s): %s", name, ungroupedLines);
    }

    @AutoValue
    static abstract class OverloadKey {
        OverloadKey() {
        }

        abstract Name name();

        public static OverloadKey create(MethodTree methodTree) {
            Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)methodTree);
            return new AutoValue_UngroupedOverloads_OverloadKey(sym.getSimpleName());
        }
    }

    @AutoValue
    static abstract class MemberWithIndex {
        MemberWithIndex() {
        }

        abstract int index();

        abstract Tree tree();

        static MemberWithIndex create(int index, Tree tree) {
            return new AutoValue_UngroupedOverloads_MemberWithIndex(index, tree);
        }
    }
}

