/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.base.Preconditions;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.fixes.Replacements;
import com.sun.tools.javac.tree.EndPosTable;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;

public class AppliedFix {
    private final String snippet;
    private final boolean isRemoveLine;

    private AppliedFix(String snippet, boolean isRemoveLine) {
        this.snippet = snippet;
        this.isRemoveLine = isRemoveLine;
    }

    public CharSequence getNewCodeSnippet() {
        return this.snippet;
    }

    public boolean isRemoveLine() {
        return this.isRemoveLine;
    }

    public static Applier fromSource(CharSequence source, EndPosTable endPositions) {
        return new Applier(source, endPositions);
    }

    public static class Applier {
        private final CharSequence source;
        private final EndPosTable endPositions;

        public Applier(CharSequence source, EndPosTable endPositions) {
            this.source = source;
            this.endPositions = endPositions;
        }

        public AppliedFix apply(Fix suggestedFix) {
            StringBuilder replaced = new StringBuilder(this.source);
            Set<Replacement> replacements = Applier.descending(suggestedFix.getReplacements(this.endPositions));
            HashSet<Integer> modifiedLines = new HashSet<Integer>();
            for (Replacement repl : replacements) {
                Preconditions.checkArgument((repl.endPosition() <= this.source.length() ? 1 : 0) != 0, (String)"End [%s] should not exceed source length [%s]", (int)repl.endPosition(), (int)this.source.length());
                replaced.replace(repl.startPosition(), repl.endPosition(), repl.replaceWith());
                try {
                    LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(this.source.toString()));
                    lineNumberReader.skip(repl.startPosition());
                    modifiedLines.add(lineNumberReader.getLineNumber());
                }
                catch (IOException lineNumberReader) {}
            }
            if (modifiedLines.isEmpty()) {
                return null;
            }
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(replaced.toString()));
            String snippet = null;
            boolean isRemoveLine = false;
            try {
                while (!modifiedLines.contains(lineNumberReader.getLineNumber())) {
                    lineNumberReader.readLine();
                }
                snippet = lineNumberReader.readLine();
                if (snippet == null) {
                    snippet = "";
                } else if ((snippet = snippet.trim()).contains("//")) {
                    snippet = snippet.substring(0, snippet.indexOf("//")).trim();
                }
                if (snippet.isEmpty()) {
                    isRemoveLine = true;
                    snippet = "to remove this line";
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new AppliedFix(snippet, isRemoveLine);
        }

        private static Set<Replacement> descending(Set<Replacement> set) {
            Replacements replacements = new Replacements();
            set.forEach(replacements::add);
            return replacements.descending();
        }
    }
}

