/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.type;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.AutoValue_Type_ArrayTy;
import com.google.turbine.type.AutoValue_Type_ClassTy;
import com.google.turbine.type.AutoValue_Type_ClassTy_SimpleClassTy;
import com.google.turbine.type.AutoValue_Type_ErrorTy;
import com.google.turbine.type.AutoValue_Type_IntersectionTy;
import com.google.turbine.type.AutoValue_Type_PrimTy;
import com.google.turbine.type.AutoValue_Type_TyVar;
import com.google.turbine.type.AutoValue_Type_WildLowerBoundedTy;
import com.google.turbine.type.AutoValue_Type_WildUnboundedTy;
import com.google.turbine.type.AutoValue_Type_WildUpperBoundedTy;
import java.util.Arrays;

public interface Type {
    public static final Type VOID = new Type(){

        @Override
        public TyKind tyKind() {
            return TyKind.VOID_TY;
        }
    };

    public TyKind tyKind();

    @AutoValue
    public static abstract class ErrorTy
    implements Type {
        public static ErrorTy create() {
            return new AutoValue_Type_ErrorTy();
        }

        @Override
        public TyKind tyKind() {
            return TyKind.ERROR_TY;
        }
    }

    @AutoValue
    public static abstract class IntersectionTy
    implements Type {
        public abstract ImmutableList<Type> bounds();

        public static IntersectionTy create(ImmutableList<Type> bounds) {
            return new AutoValue_Type_IntersectionTy(bounds);
        }

        @Override
        public TyKind tyKind() {
            return TyKind.INTERSECTION_TY;
        }
    }

    @AutoValue
    public static abstract class WildUnboundedTy
    extends WildTy {
        public static WildUnboundedTy create(ImmutableList<AnnoInfo> annotations) {
            return new AutoValue_Type_WildUnboundedTy(annotations);
        }

        @Override
        public WildTy.BoundKind boundKind() {
            return WildTy.BoundKind.NONE;
        }

        @Override
        public Type bound() {
            throw new IllegalStateException();
        }
    }

    @AutoValue
    public static abstract class WildLowerBoundedTy
    extends WildTy {
        public static WildLowerBoundedTy create(Type bound, ImmutableList<AnnoInfo> annotations) {
            return new AutoValue_Type_WildLowerBoundedTy(annotations, bound);
        }

        @Override
        public abstract Type bound();

        @Override
        public WildTy.BoundKind boundKind() {
            return WildTy.BoundKind.LOWER;
        }
    }

    @AutoValue
    public static abstract class WildUpperBoundedTy
    extends WildTy {
        public static WildUpperBoundedTy create(Type bound, ImmutableList<AnnoInfo> annotations) {
            return new AutoValue_Type_WildUpperBoundedTy(annotations, bound);
        }

        @Override
        public abstract Type bound();

        @Override
        public WildTy.BoundKind boundKind() {
            return WildTy.BoundKind.UPPER;
        }
    }

    public static abstract class WildTy
    implements Type {
        public abstract BoundKind boundKind();

        public abstract Type bound();

        public abstract ImmutableList<AnnoInfo> annotations();

        @Override
        public TyKind tyKind() {
            return TyKind.WILD_TY;
        }

        public static enum BoundKind {
            NONE,
            UPPER,
            LOWER;

        }
    }

    @AutoValue
    public static abstract class PrimTy
    implements Type {
        public static PrimTy create(TurbineConstantTypeKind tykind, ImmutableList<AnnoInfo> annos) {
            return new AutoValue_Type_PrimTy(tykind, annos);
        }

        public abstract TurbineConstantTypeKind primkind();

        @Override
        public TyKind tyKind() {
            return TyKind.PRIM_TY;
        }

        public abstract ImmutableList<AnnoInfo> annos();
    }

    @AutoValue
    public static abstract class TyVar
    implements Type {
        public static TyVar create(TyVarSymbol sym, ImmutableList<AnnoInfo> annos) {
            return new AutoValue_Type_TyVar(sym, annos);
        }

        public abstract TyVarSymbol sym();

        @Override
        public TyKind tyKind() {
            return TyKind.TY_VAR;
        }

        public final String toString() {
            return this.sym().owner() + "#" + this.sym().name();
        }

        public abstract ImmutableList<AnnoInfo> annos();
    }

    @AutoValue
    public static abstract class ArrayTy
    implements Type {
        public static ArrayTy create(Type elem, ImmutableList<AnnoInfo> annos) {
            return new AutoValue_Type_ArrayTy(elem, annos);
        }

        public abstract Type elementType();

        @Override
        public TyKind tyKind() {
            return TyKind.ARRAY_TY;
        }

        public abstract ImmutableList<AnnoInfo> annos();
    }

    @AutoValue
    public static abstract class ClassTy
    implements Type {
        public static final ClassTy OBJECT = ClassTy.asNonParametricClassTy(ClassSymbol.OBJECT);
        public static final ClassTy STRING = ClassTy.asNonParametricClassTy(ClassSymbol.STRING);

        public static ClassTy asNonParametricClassTy(ClassSymbol i) {
            return ClassTy.create(Arrays.asList(SimpleClassTy.create(i, (ImmutableList<Type>)ImmutableList.of(), (ImmutableList<AnnoInfo>)ImmutableList.of())));
        }

        public abstract ImmutableList<SimpleClassTy> classes();

        public static ClassTy create(Iterable<SimpleClassTy> classes) {
            return new AutoValue_Type_ClassTy((ImmutableList<SimpleClassTy>)ImmutableList.copyOf(classes));
        }

        @Override
        public TyKind tyKind() {
            return TyKind.CLASS_TY;
        }

        public ClassSymbol sym() {
            return ((SimpleClassTy)Iterables.getLast(this.classes())).sym();
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (SimpleClassTy c : this.classes()) {
                if (!first) {
                    sb.append('.');
                    sb.append(c.sym().binaryName().substring(c.sym().binaryName().lastIndexOf(36) + 1));
                } else {
                    sb.append(c.sym().binaryName());
                }
                if (!c.targs().isEmpty()) {
                    sb.append('<');
                    Joiner.on((char)',').appendTo(sb, c.targs());
                    sb.append('>');
                }
                first = false;
            }
            return sb.toString();
        }

        @AutoValue
        public static abstract class SimpleClassTy {
            public static SimpleClassTy create(ClassSymbol sym, ImmutableList<Type> targs, ImmutableList<AnnoInfo> annos) {
                return new AutoValue_Type_ClassTy_SimpleClassTy(sym, targs, annos);
            }

            public abstract ClassSymbol sym();

            public abstract ImmutableList<Type> targs();

            public abstract ImmutableList<AnnoInfo> annos();
        }
    }

    public static enum TyKind {
        PRIM_TY,
        VOID_TY,
        CLASS_TY,
        ARRAY_TY,
        TY_VAR,
        WILD_TY,
        INTERSECTION_TY,
        ERROR_TY;

    }
}

