/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.common.base.Utf8;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Modifier;

@BugPattern(name="IsLoggableTagLength", summary="Log tag too long, cannot exceed 23 characters.", category=BugPattern.Category.ANDROID, severity=BugPattern.SeverityLevel.ERROR)
public class IsLoggableTagLength
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> IS_LOGGABLE_CALL = MethodMatchers.staticMethod().onClass("android.util.Log").named("isLoggable");
    private static final Matcher<ExpressionTree> GET_SIMPLE_NAME_CALL = MethodMatchers.instanceMethod().onExactClass("java.lang.Class").named("getSimpleName");
    private static final Matcher<MethodInvocationTree> RECEIVER_IS_CLASS_LITERAL = Matchers.receiverOfInvocation((Matcher)Matchers.classLiteral((Matcher)Matchers.anything()));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!IS_LOGGABLE_CALL.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree tagArg = tree.getArguments().get(0);
        String tagConstantValue = (String)ASTHelpers.constValue((Tree)tagArg, String.class);
        if (tagConstantValue != null) {
            return this.isValidTag(tagConstantValue) ? Description.NO_MATCH : this.describeMatch(tagArg);
        }
        ExpressionTree tagExpr = tagArg;
        if (Matchers.kindIs((Tree.Kind)Tree.Kind.IDENTIFIER).matches((Tree)tagArg, state)) {
            VariableTree declaredField = this.findEnclosingIdentifier((IdentifierTree)tagArg, state);
            if (declaredField == null || !Matchers.hasModifier((Modifier)Modifier.FINAL).matches((Tree)declaredField, state)) {
                return Description.NO_MATCH;
            }
            tagExpr = declaredField.getInitializer();
        }
        if (GET_SIMPLE_NAME_CALL.matches((Tree)tagExpr, state) && RECEIVER_IS_CLASS_LITERAL.matches((Tree)((MethodInvocationTree)tagExpr), state)) {
            String tagName = ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)ASTHelpers.getReceiver((ExpressionTree)tagExpr))).getSimpleName().toString();
            return this.isValidTag(tagName) ? Description.NO_MATCH : this.describeMatch(tagArg);
        }
        return Description.NO_MATCH;
    }

    private boolean isValidTag(String tag) {
        return Utf8.encodedLength((CharSequence)tag) <= 23;
    }

    private VariableTree findEnclosingIdentifier(IdentifierTree originalNode, VisitorState state) {
        final Symbol identifierSymbol = ASTHelpers.getSymbol((Tree)originalNode);
        if (!(identifierSymbol instanceof Symbol.VarSymbol)) {
            return null;
        }
        return ((ClassTree)state.findEnclosing(new Class[]{ClassTree.class})).accept(new TreeScanner<VariableTree, Void>(){

            @Override
            public VariableTree visitVariable(VariableTree node, Void p) {
                return ASTHelpers.getSymbol((VariableTree)node).equals(identifierSymbol) ? node : null;
            }

            @Override
            public VariableTree reduce(VariableTree r1, VariableTree r2) {
                return r1 != null ? r1 : r2;
            }
        }, null);
    }
}

