// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: build/bazel/remote/execution/v2/remote_execution.proto

package build.bazel.remote.execution.v2;

/**
 * <pre>
 * An `Action` captures all the information about an execution which is required
 * to reproduce it.
 * `Action`s are the core component of the [Execution] service. A single
 * `Action` represents a repeatable action that can be performed by the
 * execution service. `Action`s can be succinctly identified by the digest of
 * their wire format encoding and, once an `Action` has been executed, will be
 * cached in the action cache. Future requests can then use the cached result
 * rather than needing to run afresh.
 * When a server completes execution of an
 * [Action][build.bazel.remote.execution.v2.Action], it MAY choose to
 * cache the [result][build.bazel.remote.execution.v2.ActionResult] in
 * the [ActionCache][build.bazel.remote.execution.v2.ActionCache] unless
 * `do_not_cache` is `true`. Clients SHOULD expect the server to do so. By
 * default, future calls to
 * [Execute][build.bazel.remote.execution.v2.Execution.Execute] the same
 * `Action` will also serve their results from the cache. Clients must take care
 * to understand the caching behaviour. Ideally, all `Action`s will be
 * reproducible so that serving a result from cache is always desirable and
 * correct.
 * </pre>
 *
 * Protobuf type {@code build.bazel.remote.execution.v2.Action}
 */
public  final class Action extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:build.bazel.remote.execution.v2.Action)
    ActionOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Action.newBuilder() to construct.
  private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Action() {
    doNotCache_ = false;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Action(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            build.bazel.remote.execution.v2.Digest.Builder subBuilder = null;
            if (commandDigest_ != null) {
              subBuilder = commandDigest_.toBuilder();
            }
            commandDigest_ = input.readMessage(build.bazel.remote.execution.v2.Digest.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(commandDigest_);
              commandDigest_ = subBuilder.buildPartial();
            }

            break;
          }
          case 18: {
            build.bazel.remote.execution.v2.Digest.Builder subBuilder = null;
            if (inputRootDigest_ != null) {
              subBuilder = inputRootDigest_.toBuilder();
            }
            inputRootDigest_ = input.readMessage(build.bazel.remote.execution.v2.Digest.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(inputRootDigest_);
              inputRootDigest_ = subBuilder.buildPartial();
            }

            break;
          }
          case 50: {
            com.google.protobuf.Duration.Builder subBuilder = null;
            if (timeout_ != null) {
              subBuilder = timeout_.toBuilder();
            }
            timeout_ = input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(timeout_);
              timeout_ = subBuilder.buildPartial();
            }

            break;
          }
          case 56: {

            doNotCache_ = input.readBool();
            break;
          }
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Action_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Action_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            build.bazel.remote.execution.v2.Action.class, build.bazel.remote.execution.v2.Action.Builder.class);
  }

  public static final int COMMAND_DIGEST_FIELD_NUMBER = 1;
  private build.bazel.remote.execution.v2.Digest commandDigest_;
  /**
   * <pre>
   * The digest of the [Command][build.bazel.remote.execution.v2.Command]
   * to run, which MUST be present in the
   * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
   */
  public boolean hasCommandDigest() {
    return commandDigest_ != null;
  }
  /**
   * <pre>
   * The digest of the [Command][build.bazel.remote.execution.v2.Command]
   * to run, which MUST be present in the
   * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
   */
  public build.bazel.remote.execution.v2.Digest getCommandDigest() {
    return commandDigest_ == null ? build.bazel.remote.execution.v2.Digest.getDefaultInstance() : commandDigest_;
  }
  /**
   * <pre>
   * The digest of the [Command][build.bazel.remote.execution.v2.Command]
   * to run, which MUST be present in the
   * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
   */
  public build.bazel.remote.execution.v2.DigestOrBuilder getCommandDigestOrBuilder() {
    return getCommandDigest();
  }

  public static final int INPUT_ROOT_DIGEST_FIELD_NUMBER = 2;
  private build.bazel.remote.execution.v2.Digest inputRootDigest_;
  /**
   * <pre>
   * The digest of the root
   * [Directory][build.bazel.remote.execution.v2.Directory] for the input
   * files. The files in the directory tree are available in the correct
   * location on the build machine before the command is executed. The root
   * directory, as well as every subdirectory and content blob referred to, MUST
   * be in the
   * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
   */
  public boolean hasInputRootDigest() {
    return inputRootDigest_ != null;
  }
  /**
   * <pre>
   * The digest of the root
   * [Directory][build.bazel.remote.execution.v2.Directory] for the input
   * files. The files in the directory tree are available in the correct
   * location on the build machine before the command is executed. The root
   * directory, as well as every subdirectory and content blob referred to, MUST
   * be in the
   * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
   */
  public build.bazel.remote.execution.v2.Digest getInputRootDigest() {
    return inputRootDigest_ == null ? build.bazel.remote.execution.v2.Digest.getDefaultInstance() : inputRootDigest_;
  }
  /**
   * <pre>
   * The digest of the root
   * [Directory][build.bazel.remote.execution.v2.Directory] for the input
   * files. The files in the directory tree are available in the correct
   * location on the build machine before the command is executed. The root
   * directory, as well as every subdirectory and content blob referred to, MUST
   * be in the
   * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
   * </pre>
   *
   * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
   */
  public build.bazel.remote.execution.v2.DigestOrBuilder getInputRootDigestOrBuilder() {
    return getInputRootDigest();
  }

  public static final int TIMEOUT_FIELD_NUMBER = 6;
  private com.google.protobuf.Duration timeout_;
  /**
   * <pre>
   * A timeout after which the execution should be killed. If the timeout is
   * absent, then the client is specifying that the execution should continue
   * as long as the server will let it. The server SHOULD impose a timeout if
   * the client does not specify one, however, if the client does specify a
   * timeout that is longer than the server's maximum timeout, the server MUST
   * reject the request.
   * The timeout is a part of the
   * [Action][build.bazel.remote.execution.v2.Action] message, and
   * therefore two `Actions` with different timeouts are different, even if they
   * are otherwise identical. This is because, if they were not, running an
   * `Action` with a lower timeout than is required might result in a cache hit
   * from an execution run with a longer timeout, hiding the fact that the
   * timeout is too short. By encoding it directly in the `Action`, a lower
   * timeout will result in a cache miss and the execution timeout will fail
   * immediately, rather than whenever the cache entry gets evicted.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   */
  public boolean hasTimeout() {
    return timeout_ != null;
  }
  /**
   * <pre>
   * A timeout after which the execution should be killed. If the timeout is
   * absent, then the client is specifying that the execution should continue
   * as long as the server will let it. The server SHOULD impose a timeout if
   * the client does not specify one, however, if the client does specify a
   * timeout that is longer than the server's maximum timeout, the server MUST
   * reject the request.
   * The timeout is a part of the
   * [Action][build.bazel.remote.execution.v2.Action] message, and
   * therefore two `Actions` with different timeouts are different, even if they
   * are otherwise identical. This is because, if they were not, running an
   * `Action` with a lower timeout than is required might result in a cache hit
   * from an execution run with a longer timeout, hiding the fact that the
   * timeout is too short. By encoding it directly in the `Action`, a lower
   * timeout will result in a cache miss and the execution timeout will fail
   * immediately, rather than whenever the cache entry gets evicted.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   */
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   * <pre>
   * A timeout after which the execution should be killed. If the timeout is
   * absent, then the client is specifying that the execution should continue
   * as long as the server will let it. The server SHOULD impose a timeout if
   * the client does not specify one, however, if the client does specify a
   * timeout that is longer than the server's maximum timeout, the server MUST
   * reject the request.
   * The timeout is a part of the
   * [Action][build.bazel.remote.execution.v2.Action] message, and
   * therefore two `Actions` with different timeouts are different, even if they
   * are otherwise identical. This is because, if they were not, running an
   * `Action` with a lower timeout than is required might result in a cache hit
   * from an execution run with a longer timeout, hiding the fact that the
   * timeout is too short. By encoding it directly in the `Action`, a lower
   * timeout will result in a cache miss and the execution timeout will fail
   * immediately, rather than whenever the cache entry gets evicted.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   */
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return getTimeout();
  }

  public static final int DO_NOT_CACHE_FIELD_NUMBER = 7;
  private boolean doNotCache_;
  /**
   * <pre>
   * If true, then the `Action`'s result cannot be cached.
   * </pre>
   *
   * <code>bool do_not_cache = 7;</code>
   */
  public boolean getDoNotCache() {
    return doNotCache_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (commandDigest_ != null) {
      output.writeMessage(1, getCommandDigest());
    }
    if (inputRootDigest_ != null) {
      output.writeMessage(2, getInputRootDigest());
    }
    if (timeout_ != null) {
      output.writeMessage(6, getTimeout());
    }
    if (doNotCache_ != false) {
      output.writeBool(7, doNotCache_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (commandDigest_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getCommandDigest());
    }
    if (inputRootDigest_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getInputRootDigest());
    }
    if (timeout_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, getTimeout());
    }
    if (doNotCache_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(7, doNotCache_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof build.bazel.remote.execution.v2.Action)) {
      return super.equals(obj);
    }
    build.bazel.remote.execution.v2.Action other = (build.bazel.remote.execution.v2.Action) obj;

    boolean result = true;
    result = result && (hasCommandDigest() == other.hasCommandDigest());
    if (hasCommandDigest()) {
      result = result && getCommandDigest()
          .equals(other.getCommandDigest());
    }
    result = result && (hasInputRootDigest() == other.hasInputRootDigest());
    if (hasInputRootDigest()) {
      result = result && getInputRootDigest()
          .equals(other.getInputRootDigest());
    }
    result = result && (hasTimeout() == other.hasTimeout());
    if (hasTimeout()) {
      result = result && getTimeout()
          .equals(other.getTimeout());
    }
    result = result && (getDoNotCache()
        == other.getDoNotCache());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCommandDigest()) {
      hash = (37 * hash) + COMMAND_DIGEST_FIELD_NUMBER;
      hash = (53 * hash) + getCommandDigest().hashCode();
    }
    if (hasInputRootDigest()) {
      hash = (37 * hash) + INPUT_ROOT_DIGEST_FIELD_NUMBER;
      hash = (53 * hash) + getInputRootDigest().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (37 * hash) + DO_NOT_CACHE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getDoNotCache());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static build.bazel.remote.execution.v2.Action parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Action parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static build.bazel.remote.execution.v2.Action parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static build.bazel.remote.execution.v2.Action parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(build.bazel.remote.execution.v2.Action prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * An `Action` captures all the information about an execution which is required
   * to reproduce it.
   * `Action`s are the core component of the [Execution] service. A single
   * `Action` represents a repeatable action that can be performed by the
   * execution service. `Action`s can be succinctly identified by the digest of
   * their wire format encoding and, once an `Action` has been executed, will be
   * cached in the action cache. Future requests can then use the cached result
   * rather than needing to run afresh.
   * When a server completes execution of an
   * [Action][build.bazel.remote.execution.v2.Action], it MAY choose to
   * cache the [result][build.bazel.remote.execution.v2.ActionResult] in
   * the [ActionCache][build.bazel.remote.execution.v2.ActionCache] unless
   * `do_not_cache` is `true`. Clients SHOULD expect the server to do so. By
   * default, future calls to
   * [Execute][build.bazel.remote.execution.v2.Execution.Execute] the same
   * `Action` will also serve their results from the cache. Clients must take care
   * to understand the caching behaviour. Ideally, all `Action`s will be
   * reproducible so that serving a result from cache is always desirable and
   * correct.
   * </pre>
   *
   * Protobuf type {@code build.bazel.remote.execution.v2.Action}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:build.bazel.remote.execution.v2.Action)
      build.bazel.remote.execution.v2.ActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Action_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Action_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              build.bazel.remote.execution.v2.Action.class, build.bazel.remote.execution.v2.Action.Builder.class);
    }

    // Construct using build.bazel.remote.execution.v2.Action.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (commandDigestBuilder_ == null) {
        commandDigest_ = null;
      } else {
        commandDigest_ = null;
        commandDigestBuilder_ = null;
      }
      if (inputRootDigestBuilder_ == null) {
        inputRootDigest_ = null;
      } else {
        inputRootDigest_ = null;
        inputRootDigestBuilder_ = null;
      }
      if (timeoutBuilder_ == null) {
        timeout_ = null;
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }
      doNotCache_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return build.bazel.remote.execution.v2.RemoteExecutionProto.internal_static_build_bazel_remote_execution_v2_Action_descriptor;
    }

    @java.lang.Override
    public build.bazel.remote.execution.v2.Action getDefaultInstanceForType() {
      return build.bazel.remote.execution.v2.Action.getDefaultInstance();
    }

    @java.lang.Override
    public build.bazel.remote.execution.v2.Action build() {
      build.bazel.remote.execution.v2.Action result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public build.bazel.remote.execution.v2.Action buildPartial() {
      build.bazel.remote.execution.v2.Action result = new build.bazel.remote.execution.v2.Action(this);
      if (commandDigestBuilder_ == null) {
        result.commandDigest_ = commandDigest_;
      } else {
        result.commandDigest_ = commandDigestBuilder_.build();
      }
      if (inputRootDigestBuilder_ == null) {
        result.inputRootDigest_ = inputRootDigest_;
      } else {
        result.inputRootDigest_ = inputRootDigestBuilder_.build();
      }
      if (timeoutBuilder_ == null) {
        result.timeout_ = timeout_;
      } else {
        result.timeout_ = timeoutBuilder_.build();
      }
      result.doNotCache_ = doNotCache_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return (Builder) super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof build.bazel.remote.execution.v2.Action) {
        return mergeFrom((build.bazel.remote.execution.v2.Action)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(build.bazel.remote.execution.v2.Action other) {
      if (other == build.bazel.remote.execution.v2.Action.getDefaultInstance()) return this;
      if (other.hasCommandDigest()) {
        mergeCommandDigest(other.getCommandDigest());
      }
      if (other.hasInputRootDigest()) {
        mergeInputRootDigest(other.getInputRootDigest());
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (other.getDoNotCache() != false) {
        setDoNotCache(other.getDoNotCache());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      build.bazel.remote.execution.v2.Action parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (build.bazel.remote.execution.v2.Action) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private build.bazel.remote.execution.v2.Digest commandDigest_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        build.bazel.remote.execution.v2.Digest, build.bazel.remote.execution.v2.Digest.Builder, build.bazel.remote.execution.v2.DigestOrBuilder> commandDigestBuilder_;
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public boolean hasCommandDigest() {
      return commandDigestBuilder_ != null || commandDigest_ != null;
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public build.bazel.remote.execution.v2.Digest getCommandDigest() {
      if (commandDigestBuilder_ == null) {
        return commandDigest_ == null ? build.bazel.remote.execution.v2.Digest.getDefaultInstance() : commandDigest_;
      } else {
        return commandDigestBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public Builder setCommandDigest(build.bazel.remote.execution.v2.Digest value) {
      if (commandDigestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commandDigest_ = value;
        onChanged();
      } else {
        commandDigestBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public Builder setCommandDigest(
        build.bazel.remote.execution.v2.Digest.Builder builderForValue) {
      if (commandDigestBuilder_ == null) {
        commandDigest_ = builderForValue.build();
        onChanged();
      } else {
        commandDigestBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public Builder mergeCommandDigest(build.bazel.remote.execution.v2.Digest value) {
      if (commandDigestBuilder_ == null) {
        if (commandDigest_ != null) {
          commandDigest_ =
            build.bazel.remote.execution.v2.Digest.newBuilder(commandDigest_).mergeFrom(value).buildPartial();
        } else {
          commandDigest_ = value;
        }
        onChanged();
      } else {
        commandDigestBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public Builder clearCommandDigest() {
      if (commandDigestBuilder_ == null) {
        commandDigest_ = null;
        onChanged();
      } else {
        commandDigest_ = null;
        commandDigestBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public build.bazel.remote.execution.v2.Digest.Builder getCommandDigestBuilder() {
      
      onChanged();
      return getCommandDigestFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    public build.bazel.remote.execution.v2.DigestOrBuilder getCommandDigestOrBuilder() {
      if (commandDigestBuilder_ != null) {
        return commandDigestBuilder_.getMessageOrBuilder();
      } else {
        return commandDigest_ == null ?
            build.bazel.remote.execution.v2.Digest.getDefaultInstance() : commandDigest_;
      }
    }
    /**
     * <pre>
     * The digest of the [Command][build.bazel.remote.execution.v2.Command]
     * to run, which MUST be present in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest command_digest = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        build.bazel.remote.execution.v2.Digest, build.bazel.remote.execution.v2.Digest.Builder, build.bazel.remote.execution.v2.DigestOrBuilder> 
        getCommandDigestFieldBuilder() {
      if (commandDigestBuilder_ == null) {
        commandDigestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            build.bazel.remote.execution.v2.Digest, build.bazel.remote.execution.v2.Digest.Builder, build.bazel.remote.execution.v2.DigestOrBuilder>(
                getCommandDigest(),
                getParentForChildren(),
                isClean());
        commandDigest_ = null;
      }
      return commandDigestBuilder_;
    }

    private build.bazel.remote.execution.v2.Digest inputRootDigest_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        build.bazel.remote.execution.v2.Digest, build.bazel.remote.execution.v2.Digest.Builder, build.bazel.remote.execution.v2.DigestOrBuilder> inputRootDigestBuilder_;
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public boolean hasInputRootDigest() {
      return inputRootDigestBuilder_ != null || inputRootDigest_ != null;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public build.bazel.remote.execution.v2.Digest getInputRootDigest() {
      if (inputRootDigestBuilder_ == null) {
        return inputRootDigest_ == null ? build.bazel.remote.execution.v2.Digest.getDefaultInstance() : inputRootDigest_;
      } else {
        return inputRootDigestBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public Builder setInputRootDigest(build.bazel.remote.execution.v2.Digest value) {
      if (inputRootDigestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputRootDigest_ = value;
        onChanged();
      } else {
        inputRootDigestBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public Builder setInputRootDigest(
        build.bazel.remote.execution.v2.Digest.Builder builderForValue) {
      if (inputRootDigestBuilder_ == null) {
        inputRootDigest_ = builderForValue.build();
        onChanged();
      } else {
        inputRootDigestBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public Builder mergeInputRootDigest(build.bazel.remote.execution.v2.Digest value) {
      if (inputRootDigestBuilder_ == null) {
        if (inputRootDigest_ != null) {
          inputRootDigest_ =
            build.bazel.remote.execution.v2.Digest.newBuilder(inputRootDigest_).mergeFrom(value).buildPartial();
        } else {
          inputRootDigest_ = value;
        }
        onChanged();
      } else {
        inputRootDigestBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public Builder clearInputRootDigest() {
      if (inputRootDigestBuilder_ == null) {
        inputRootDigest_ = null;
        onChanged();
      } else {
        inputRootDigest_ = null;
        inputRootDigestBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public build.bazel.remote.execution.v2.Digest.Builder getInputRootDigestBuilder() {
      
      onChanged();
      return getInputRootDigestFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    public build.bazel.remote.execution.v2.DigestOrBuilder getInputRootDigestOrBuilder() {
      if (inputRootDigestBuilder_ != null) {
        return inputRootDigestBuilder_.getMessageOrBuilder();
      } else {
        return inputRootDigest_ == null ?
            build.bazel.remote.execution.v2.Digest.getDefaultInstance() : inputRootDigest_;
      }
    }
    /**
     * <pre>
     * The digest of the root
     * [Directory][build.bazel.remote.execution.v2.Directory] for the input
     * files. The files in the directory tree are available in the correct
     * location on the build machine before the command is executed. The root
     * directory, as well as every subdirectory and content blob referred to, MUST
     * be in the
     * [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
     * </pre>
     *
     * <code>.build.bazel.remote.execution.v2.Digest input_root_digest = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        build.bazel.remote.execution.v2.Digest, build.bazel.remote.execution.v2.Digest.Builder, build.bazel.remote.execution.v2.DigestOrBuilder> 
        getInputRootDigestFieldBuilder() {
      if (inputRootDigestBuilder_ == null) {
        inputRootDigestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            build.bazel.remote.execution.v2.Digest, build.bazel.remote.execution.v2.Digest.Builder, build.bazel.remote.execution.v2.DigestOrBuilder>(
                getInputRootDigest(),
                getParentForChildren(),
                isClean());
        inputRootDigest_ = null;
      }
      return inputRootDigestBuilder_;
    }

    private com.google.protobuf.Duration timeout_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> timeoutBuilder_;
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public boolean hasTimeout() {
      return timeoutBuilder_ != null || timeout_ != null;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
        onChanged();
      } else {
        timeoutBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder setTimeout(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
        onChanged();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (timeout_ != null) {
          timeout_ =
            com.google.protobuf.Duration.newBuilder(timeout_).mergeFrom(value).buildPartial();
        } else {
          timeout_ = value;
        }
        onChanged();
      } else {
        timeoutBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder clearTimeout() {
      if (timeoutBuilder_ == null) {
        timeout_ = null;
        onChanged();
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
      
      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ?
            com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     * <pre>
     * A timeout after which the execution should be killed. If the timeout is
     * absent, then the client is specifying that the execution should continue
     * as long as the server will let it. The server SHOULD impose a timeout if
     * the client does not specify one, however, if the client does specify a
     * timeout that is longer than the server's maximum timeout, the server MUST
     * reject the request.
     * The timeout is a part of the
     * [Action][build.bazel.remote.execution.v2.Action] message, and
     * therefore two `Actions` with different timeouts are different, even if they
     * are otherwise identical. This is because, if they were not, running an
     * `Action` with a lower timeout than is required might result in a cache hit
     * from an execution run with a longer timeout, hiding the fact that the
     * timeout is too short. By encoding it directly in the `Action`, a lower
     * timeout will result in a cache miss and the execution timeout will fail
     * immediately, rather than whenever the cache entry gets evicted.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> 
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder>(
                getTimeout(),
                getParentForChildren(),
                isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private boolean doNotCache_ ;
    /**
     * <pre>
     * If true, then the `Action`'s result cannot be cached.
     * </pre>
     *
     * <code>bool do_not_cache = 7;</code>
     */
    public boolean getDoNotCache() {
      return doNotCache_;
    }
    /**
     * <pre>
     * If true, then the `Action`'s result cannot be cached.
     * </pre>
     *
     * <code>bool do_not_cache = 7;</code>
     */
    public Builder setDoNotCache(boolean value) {
      
      doNotCache_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If true, then the `Action`'s result cannot be cached.
     * </pre>
     *
     * <code>bool do_not_cache = 7;</code>
     */
    public Builder clearDoNotCache() {
      
      doNotCache_ = false;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:build.bazel.remote.execution.v2.Action)
  }

  // @@protoc_insertion_point(class_scope:build.bazel.remote.execution.v2.Action)
  private static final build.bazel.remote.execution.v2.Action DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new build.bazel.remote.execution.v2.Action();
  }

  public static build.bazel.remote.execution.v2.Action getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Action>
      PARSER = new com.google.protobuf.AbstractParser<Action>() {
    @java.lang.Override
    public Action parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Action(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Action> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Action> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public build.bazel.remote.execution.v2.Action getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

