/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.errorprone.refaster.AutoValue_UVariableDecl;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.LocalVarBinding;
import com.google.errorprone.refaster.StringName;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.ULocalVarIdent;
import com.google.errorprone.refaster.USimpleStatement;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Name;
import javax.annotation.Nullable;

@AutoValue
public abstract class UVariableDecl
extends USimpleStatement
implements VariableTree {
    public static UVariableDecl create(CharSequence identifier, UExpression type, @Nullable UExpression initializer) {
        return new AutoValue_UVariableDecl(StringName.of(identifier), type, initializer);
    }

    public static UVariableDecl create(CharSequence identifier, UExpression type) {
        return UVariableDecl.create(identifier, type, null);
    }

    @Override
    public abstract StringName getName();

    @Override
    public abstract UExpression getType();

    @Override
    @Nullable
    public abstract UExpression getInitializer();

    ULocalVarIdent.Key key() {
        return new ULocalVarIdent.Key(this.getName());
    }

    @Override
    public Choice<Unifier> visitVariable(final VariableTree decl, Unifier unifier) {
        return Choice.condition(unifier.getBinding(this.key()) == null, unifier).thenChoose(Unifier.unifications(this.getType(), decl.getType())).thenChoose(Unifier.unifications(this.getInitializer(), decl.getInitializer())).transform(new Function<Unifier, Unifier>(){

            public Unifier apply(Unifier unifier) {
                unifier.putBinding(UVariableDecl.this.key(), LocalVarBinding.create(ASTHelpers.getSymbol((VariableTree)decl), decl.getModifiers()));
                return unifier;
            }
        });
    }

    @Override
    public JCTree.JCVariableDecl inline(Inliner inliner) throws CouldNotResolveImportException {
        return this.inline(this.getType(), inliner);
    }

    public JCTree.JCVariableDecl inlineImplicitType(Inliner inliner) throws CouldNotResolveImportException {
        return this.inline(null, inliner);
    }

    private JCTree.JCVariableDecl inline(@Nullable UExpression type, Inliner inliner) throws CouldNotResolveImportException {
        Name name;
        JCTree.JCModifiers modifiers;
        Optional<LocalVarBinding> binding = inliner.getOptionalBinding(this.key());
        TreeMaker maker = inliner.maker();
        if (binding.isPresent()) {
            modifiers = (JCTree.JCModifiers)((LocalVarBinding)binding.get()).getModifiers();
            name = ((LocalVarBinding)binding.get()).getName();
        } else {
            modifiers = maker.Modifiers(0L);
            name = this.getName().inline(inliner);
        }
        return maker.VarDef(modifiers, name, type == null ? null : (JCTree.JCExpression)type.inline(inliner), this.getInitializer() == null ? null : (JCTree.JCExpression)this.getInitializer().inline(inliner));
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.VARIABLE;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitVariable(this, data);
    }

    @Override
    public ModifiersTree getModifiers() {
        return null;
    }

    @Override
    public ExpressionTree getNameExpression() {
        return null;
    }
}

