/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Abort;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.ServiceLoader;

public class JDK9Wrappers {

    public static final class JmodFile {
        public static final String JMOD_FILE_CLASSNAME = "jdk.internal.jmod.JmodFile";
        private static Class<?> jmodFileClass = null;
        private static Method checkMagicMethod = null;

        public static void checkMagic(Path path) throws IOException {
            try {
                JmodFile.init();
                checkMagicMethod.invoke(null, path);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() instanceof IOException) {
                    throw (IOException)IOException.class.cast(invocationTargetException.getCause());
                }
                throw new Abort(invocationTargetException);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
                throw new Abort(exception);
            }
        }

        private static void init() {
            if (jmodFileClass == null) {
                try {
                    jmodFileClass = Class.forName(JMOD_FILE_CLASSNAME, false, null);
                    checkMagicMethod = jmodFileClass.getDeclaredMethod("checkMagic", Path.class);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                    throw new Abort(exception);
                }
            }
        }
    }

    public static final class VMHelper {
        public static final String CLASSNAME = "jdk.internal.misc.VM";
        private static Class<?> vmClass = null;
        private static Method getRuntimeArgumentsMethod = null;

        public static String[] getRuntimeArguments() {
            try {
                VMHelper.init();
                Object object = getRuntimeArgumentsMethod.invoke(null, new Object[0]);
                return (String[])object;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                throw new Abort(exception);
            }
        }

        private static void init() {
            if (vmClass == null) {
                try {
                    vmClass = Class.forName(CLASSNAME, false, null);
                    getRuntimeArgumentsMethod = vmClass.getDeclaredMethod("getRuntimeArguments", new Class[0]);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                    throw new Abort(exception);
                }
            }
        }
    }

    public static final class Layer {
        private final Object theRealLayer;
        private static Class<?> layerClass = null;
        private static Method bootMethod;
        private static Method defineModulesWithOneLoaderMethod;
        private static Method configurationMethod;

        private Layer(Object object) {
            this.theRealLayer = object;
        }

        public static Layer boot() {
            try {
                Layer.init();
                Object object = bootMethod.invoke(null, new Object[0]);
                Layer layer = new Layer(object);
                return layer;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                throw new Abort(exception);
            }
        }

        public Configuration configuration() {
            try {
                Object object = configurationMethod.invoke(this.theRealLayer, new Object[0]);
                Configuration configuration = new Configuration(object);
                return configuration;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                throw new Abort(exception);
            }
        }

        public Layer defineModulesWithOneLoader(Configuration configuration, ClassLoader classLoader) {
            try {
                Object object = defineModulesWithOneLoaderMethod.invoke(this.theRealLayer, configuration.theRealConfiguration, classLoader);
                Layer layer = new Layer(object);
                return layer;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                throw new Abort(exception);
            }
        }

        private static void init() {
            if (layerClass == null) {
                try {
                    layerClass = Class.forName("java.lang.ModuleLayer", false, null);
                    bootMethod = layerClass.getDeclaredMethod("boot", new Class[0]);
                    defineModulesWithOneLoaderMethod = layerClass.getDeclaredMethod("defineModulesWithOneLoader", Configuration.getConfigurationClass(), ClassLoader.class);
                    configurationMethod = layerClass.getDeclaredMethod("configuration", new Class[0]);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                    throw new Abort(exception);
                }
            }
        }
    }

    public static final class Configuration {
        private final Object theRealConfiguration;
        private static Class<?> configurationClass = null;
        private static Method resolveAndBindMethod;

        private Configuration(Object object) {
            this.theRealConfiguration = object;
            Configuration.init();
        }

        public Configuration resolveAndBind(ModuleFinder moduleFinder, ModuleFinder moduleFinder2, Collection<String> collection) {
            try {
                Object object = resolveAndBindMethod.invoke(this.theRealConfiguration, moduleFinder.theRealModuleFinder, moduleFinder2.theRealModuleFinder, collection);
                Configuration configuration = new Configuration(object);
                return configuration;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                throw new Abort(exception);
            }
        }

        static final Class<?> getConfigurationClass() {
            Configuration.init();
            return configurationClass;
        }

        private static void init() {
            if (configurationClass == null) {
                try {
                    configurationClass = Class.forName("java.lang.module.Configuration", false, null);
                    Class<?> clazz = ModuleFinder.getModuleFinderClass();
                    resolveAndBindMethod = configurationClass.getDeclaredMethod("resolveAndBind", clazz, clazz, Collection.class);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                    throw new Abort(exception);
                }
            }
        }
    }

    public static class Module {
        private final Object theRealModule;
        private static Method addExportsMethod = null;
        private static Method addUsesMethod = null;
        private static Method getModuleMethod;
        private static Method getUnnamedModuleMethod;

        private Module(Object object) {
            this.theRealModule = object;
            Module.init();
        }

        public static Module getModule(Class<?> clazz) {
            try {
                Module.init();
                Object object = getModuleMethod.invoke(clazz, new Object[0]);
                return new Module(object);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                throw new Abort(exception);
            }
        }

        public static Module getUnnamedModule(ClassLoader classLoader) {
            try {
                Module.init();
                Object object = getUnnamedModuleMethod.invoke((Object)classLoader, new Object[0]);
                return new Module(object);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                throw new Abort(exception);
            }
        }

        public Module addExports(String string, Module module) {
            try {
                addExportsMethod.invoke(this.theRealModule, string, module.theRealModule);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new Abort(reflectiveOperationException);
            }
            return this;
        }

        public Module addUses(Class<?> clazz) {
            try {
                addUsesMethod.invoke(this.theRealModule, clazz);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new Abort(reflectiveOperationException);
            }
            return this;
        }

        private static void init() {
            if (addExportsMethod == null) {
                try {
                    Class<?> clazz = Class.forName("java.lang.Module", false, null);
                    addUsesMethod = clazz.getDeclaredMethod("addUses", Class.class);
                    addExportsMethod = clazz.getDeclaredMethod("addExports", String.class, clazz);
                    getModuleMethod = Class.class.getDeclaredMethod("getModule", new Class[0]);
                    getUnnamedModuleMethod = ClassLoader.class.getDeclaredMethod("getUnnamedModule", new Class[0]);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                    throw new Abort(exception);
                }
            }
        }
    }

    public static class ModuleFinder {
        private final Object theRealModuleFinder;
        private static Class<?> moduleFinderClass = null;
        private static Method ofMethod;

        private ModuleFinder(Object object) {
            this.theRealModuleFinder = object;
            ModuleFinder.init();
        }

        public static ModuleFinder of(Path ... pathArray) {
            try {
                ModuleFinder.init();
                Object object = ofMethod.invoke(null, new Object[]{pathArray});
                ModuleFinder moduleFinder = new ModuleFinder(object);
                return moduleFinder;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                throw new Abort(exception);
            }
        }

        static final Class<?> getModuleFinderClass() {
            ModuleFinder.init();
            return moduleFinderClass;
        }

        private static void init() {
            if (moduleFinderClass == null) {
                try {
                    moduleFinderClass = Class.forName("java.lang.module.ModuleFinder", false, null);
                    ofMethod = moduleFinderClass.getDeclaredMethod("of", Path[].class);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                    throw new Abort(exception);
                }
            }
        }
    }

    public static class ModuleDescriptor {

        public static class Version {
            public static final String CLASSNAME = "java.lang.module.ModuleDescriptor$Version";
            private final Object theRealVersion;
            private static Class<?> versionClass = null;
            private static Method parseMethod = null;

            private Version(Object object) {
                this.theRealVersion = object;
            }

            public static Version parse(String string) {
                try {
                    Version.init();
                    Object object = parseMethod.invoke(null, string);
                    Version version = new Version(object);
                    return version;
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getCause() instanceof IllegalArgumentException) {
                        throw (IllegalArgumentException)invocationTargetException.getCause();
                    }
                    throw new Abort(invocationTargetException);
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
                    throw new Abort(exception);
                }
            }

            public String toString() {
                return this.theRealVersion.toString();
            }

            private static void init() {
                if (versionClass == null) {
                    try {
                        versionClass = Class.forName(CLASSNAME, false, null);
                        parseMethod = versionClass.getDeclaredMethod("parse", String.class);
                    }
                    catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                        throw new Abort(exception);
                    }
                }
            }
        }
    }

    public static final class ServiceLoaderHelper {
        private static Method loadMethod = null;

        public static <S> ServiceLoader<S> load(Layer layer, Class<S> clazz) {
            try {
                ServiceLoaderHelper.init();
                Object object = loadMethod.invoke(null, layer.theRealLayer, clazz);
                return (ServiceLoader)object;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                throw new Abort(exception);
            }
        }

        private static void init() {
            if (loadMethod == null) {
                try {
                    Class clazz = Layer.layerClass;
                    loadMethod = ServiceLoader.class.getDeclaredMethod("load", clazz, Class.class);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    throw new Abort(exception);
                }
            }
        }
    }
}

