/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.regex.Pattern;

@BugPattern(name="DeprecatedThreadMethods", summary="Avoid deprecated Thread methods; read the method's javadoc for details.", severity=BugPattern.SeverityLevel.WARNING)
public class DeprecatedThreadMethods
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Pattern METHOD_NAME_REGEX = Pattern.compile("stop|countStackFrames|destroy|resume|suspend");
    private static final Matcher<ExpressionTree> DEPRACATED = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.lang.Thread").withNameMatching(METHOD_NAME_REGEX)});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return DEPRACATED.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

