/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import lombok.ast.AstVisitor;
import lombok.ast.EnumConstant;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.ImportDeclaration;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class RtlDetector
extends LayoutDetector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(RtlDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.JAVA_FILE, Scope.MANIFEST), new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE});
    public static final Issue USE_START = Issue.create((String)"RtlHardcoded", (String)"Using left/right instead of start/end attributes", (String)"Using `Gravity#LEFT` and `Gravity#RIGHT` can lead to problems when a layout is rendered in locales where text flows from right to left. Use `Gravity#START` and `Gravity#END` instead. Similarly, in XML `gravity` and `layout_gravity` attributes, use `start` rather than `left`.\n\nFor XML attributes such as paddingLeft and `layout_marginLeft`, use `paddingStart` and `layout_marginStart`. *NOTE*: If your `minSdkVersion` is less than 17, you should add *both* the older left/right attributes *as well as* the new start/right attributes. On older platforms, where RTL is not supported and the start/right attributes are unknown and therefore ignored, you need the older left/right attributes. There is a separate lint check which catches that type of error.\n\n(Note: For `Gravity#LEFT` and `Gravity#START`, you can use these constants even when targeting older platforms, because the `start` bitmask is a superset of the `left` bitmask. Therefore, you can use `gravity=\"start\"` rather than `gravity=\"left|start\"`.)", (Category)Category.RTL, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue COMPAT = Issue.create((String)"RtlCompat", (String)"Right-to-left text compatibility issues", (String)"API 17 adds a `textAlignment` attribute to specify text alignment. However, if you are supporting older versions than API 17, you must *also* specify a gravity or layout_gravity attribute, since older platforms will ignore the `textAlignment` attribute.", (Category)Category.RTL, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue SYMMETRY = Issue.create((String)"RtlSymmetry", (String)"Padding and margin symmetry", (String)"If you specify padding or margin on the left side of a layout, you should probably also specify padding on the right side (and vice versa) for right-to-left layout symmetry.", (Category)Category.RTL, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue ENABLED = Issue.create((String)"RtlEnabled", (String)"Using RTL attributes without enabling RTL support", (String)"To enable right-to-left support, when running on API 17 and higher, you must set the `android:supportsRtl` attribute in the manifest `<application>` element.\n\nIf you have started adding RTL attributes, but have not yet finished the migration, you can set the attribute to false to satisfy this lint check.", (Category)Category.RTL, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    private static final String RIGHT_FIELD = "RIGHT";
    private static final String LEFT_FIELD = "LEFT";
    private static final String GRAVITY_CLASS = "Gravity";
    private static final String FQCN_GRAVITY = "android.view.Gravity";
    private static final String FQCN_GRAVITY_PREFIX = "android.view.Gravity.";
    private static final String ATTR_TEXT_ALIGNMENT = "textAlignment";
    static final String ATTR_SUPPORTS_RTL = "supportsRtl";
    private static final int RTL_API = 17;
    private static final String LEFT = "Left";
    private static final String START = "Start";
    private static final String RIGHT = "Right";
    private static final String END = "End";
    private Boolean mEnabledRtlSupport;
    private boolean mUsesRtlAttributes;
    static final String[] ATTRIBUTES = new String[]{"layout_alignParentLeft", "layout_alignParentStart", "layout_alignParentRight", "layout_alignParentEnd", "layout_marginLeft", "layout_marginStart", "layout_marginRight", "layout_marginEnd", "paddingLeft", "paddingStart", "paddingRight", "paddingEnd", "drawableLeft", "drawableStart", "drawableRight", "drawableEnd", "listPreferredItemPaddingLeft", "listPreferredItemPaddingStart", "listPreferredItemPaddingRight", "listPreferredItemPaddingEnd", "layout_toLeftOf", "layout_toStartOf", "layout_toRightOf", "layout_toEndOf", "layout_alignLeft", "layout_alignStart", "layout_alignRight", "layout_alignEnd"};

    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    private boolean rtlApplies(Context context) {
        Project project = context.getMainProject();
        if (project.getTargetSdk() < 17) {
            return false;
        }
        int buildTarget = project.getBuildSdk();
        if (buildTarget != -1 && buildTarget < 17) {
            return false;
        }
        return this.mEnabledRtlSupport == null || this.mEnabledRtlSupport != false;
    }

    public void afterCheckProject(Context context) {
        List manifestFile;
        if (this.mUsesRtlAttributes && this.mEnabledRtlSupport == null && this.rtlApplies(context) && !(manifestFile = context.getMainProject().getManifestFiles()).isEmpty()) {
            Location location = Location.create((File)((File)manifestFile.get(0)));
            context.report(ENABLED, location, "The project references RTL attributes, but does not explicitly enable or disable RTL support with `android:supportsRtl` in the manifest");
        }
    }

    public static boolean isRtlAttributeName(String attribute) {
        for (int i = 1; i < ATTRIBUTES.length; i += 2) {
            if (!attribute.equals(ATTRIBUTES[i])) continue;
            return true;
        }
        return false;
    }

    static String convertOldToNew(String attribute) {
        if (attribute.contains(LEFT)) {
            return attribute.replace(LEFT, START);
        }
        return attribute.replace(RIGHT, END);
    }

    static String convertNewToOld(String attribute) {
        if (attribute.contains(START)) {
            return attribute.replace(START, LEFT);
        }
        return attribute.replace(END, RIGHT);
    }

    static String convertToOppositeDirection(String attribute) {
        if (attribute.contains(LEFT)) {
            return attribute.replace(LEFT, RIGHT);
        }
        if (attribute.contains(RIGHT)) {
            return attribute.replace(RIGHT, LEFT);
        }
        if (attribute.contains(START)) {
            return attribute.replace(START, END);
        }
        return attribute.replace(END, START);
    }

    static String getTextAlignmentToGravity(String attribute) {
        if (attribute.endsWith(START)) {
            return "start";
        }
        if (attribute.endsWith(END)) {
            return "end";
        }
        return null;
    }

    public Collection<String> getApplicableAttributes() {
        int size = ATTRIBUTES.length + 4;
        ArrayList<String> attributes = new ArrayList<String>(size);
        attributes.add(ATTR_SUPPORTS_RTL);
        attributes.add("gravity");
        attributes.add("layout_gravity");
        attributes.add(ATTR_TEXT_ALIGNMENT);
        Collections.addAll(attributes, ATTRIBUTES);
        assert (attributes.size() == size) : attributes.size();
        return attributes;
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        boolean isOld;
        Project project = context.getMainProject();
        String value = attribute.getValue();
        if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            return;
        }
        String name = attribute.getLocalName();
        assert (name != null) : attribute.getName();
        if (name.equals(ATTR_SUPPORTS_RTL)) {
            this.mEnabledRtlSupport = Boolean.valueOf(value);
            if (!attribute.getOwnerElement().getTagName().equals("application")) {
                context.report(ENABLED, (org.w3c.dom.Node)attribute, context.getLocation((org.w3c.dom.Node)attribute), String.format("Wrong declaration: `%1$s` should be defined on the `<application>` element", attribute.getName()));
            }
            int targetSdk = project.getTargetSdk();
            if (this.mEnabledRtlSupport.booleanValue() && targetSdk < 17) {
                String message = String.format("You must set `android:targetSdkVersion` to at least %1$d when enabling RTL support (is %2$d)", 17, project.getTargetSdk());
                context.report(ENABLED, (org.w3c.dom.Node)attribute, context.getValueLocation(attribute), message);
            }
            return;
        }
        if (!this.rtlApplies((Context)context)) {
            return;
        }
        if (name.equals(ATTR_TEXT_ALIGNMENT)) {
            String gravity;
            Attr gravityNode;
            Element element;
            if (context.getProject().getReportIssues()) {
                this.mUsesRtlAttributes = true;
            }
            if ((element = attribute.getOwnerElement()).hasAttributeNS("http://schemas.android.com/apk/res/android", "gravity")) {
                gravityNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "gravity");
                gravity = gravityNode.getValue();
            } else if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_gravity")) {
                gravityNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_gravity");
                gravity = gravityNode.getValue();
            } else {
                if (project.getMinSdk() < 17) {
                    String expectedGravity;
                    int folderVersion = context.getFolderVersion();
                    if (folderVersion < 17 && context.isEnabled(COMPAT) && (expectedGravity = RtlDetector.getTextAlignmentToGravity(value)) != null) {
                        String message = String.format("To support older versions than API 17 (project specifies %1$d) you must *also* specify `gravity` or `layout_gravity=\"%2$s\"`", project.getMinSdk(), expectedGravity);
                        context.report(COMPAT, (org.w3c.dom.Node)attribute, context.getNameLocation((org.w3c.dom.Node)attribute), message);
                    }
                    return;
                }
                return;
            }
            String expectedGravity = RtlDetector.getTextAlignmentToGravity(value);
            if (expectedGravity != null && !gravity.contains(expectedGravity) && context.isEnabled(COMPAT)) {
                String message = String.format("Inconsistent alignment specification between `textAlignment` and `gravity` attributes: was `%1$s`, expected `%2$s`", gravity, expectedGravity);
                Location location = context.getValueLocation(attribute);
                context.report(COMPAT, (org.w3c.dom.Node)attribute, location, message);
                Location secondary = context.getValueLocation(gravityNode);
                secondary.setMessage("Incompatible direction here");
                location.setSecondary(secondary);
            }
            return;
        }
        if (name.equals("gravity") || name.equals("layout_gravity")) {
            boolean isLeft = value.contains("left");
            boolean isRight = value.contains("right");
            if (!isLeft && !isRight) {
                if ((value.contains("start") || value.contains("end")) && context.getProject().getReportIssues()) {
                    this.mUsesRtlAttributes = true;
                }
                return;
            }
            String message = String.format("Use \"`%1$s`\" instead of \"`%2$s`\" to ensure correct behavior in right-to-left locales", isLeft ? "start" : "end", isLeft ? "left" : "right");
            if (context.isEnabled(USE_START)) {
                context.report(USE_START, (org.w3c.dom.Node)attribute, context.getValueLocation(attribute), message);
            }
            return;
        }
        int targetSdk = project.getTargetSdk();
        Element element = attribute.getOwnerElement();
        boolean isPaddingAttribute = RtlDetector.isPaddingAttribute(name);
        if (isPaddingAttribute || RtlDetector.isMarginAttribute(name)) {
            String opposite = RtlDetector.convertToOppositeDirection(name);
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", opposite)) {
                String oldValue = element.getAttributeNS("http://schemas.android.com/apk/res/android", opposite);
                if (value.equals(oldValue)) {
                    return;
                }
            } else if (isPaddingAttribute && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", RtlDetector.isOldAttribute(opposite) ? RtlDetector.convertOldToNew(opposite) : RtlDetector.convertNewToOld(opposite)) && context.isEnabled(SYMMETRY)) {
                String message = String.format("When you define `%1$s` you should probably also define `%2$s` for right-to-left symmetry", name, opposite);
                context.report(SYMMETRY, (org.w3c.dom.Node)attribute, context.getNameLocation((org.w3c.dom.Node)attribute), message);
            }
        }
        if (isOld = RtlDetector.isOldAttribute(name)) {
            if (!context.isEnabled(USE_START)) {
                return;
            }
            String rtl = RtlDetector.convertOldToNew(name);
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", rtl)) {
                if (project.getMinSdk() >= 17 || context.getFolderVersion() >= 17) {
                    String message = String.format("Redundant attribute `%1$s`; already defining `%2$s` with `targetSdkVersion` %3$s", name, rtl, targetSdk);
                    context.report(USE_START, (org.w3c.dom.Node)attribute, context.getNameLocation((org.w3c.dom.Node)attribute), message);
                }
            } else {
                String message = project.getMinSdk() >= 17 || context.getFolderVersion() >= 17 ? String.format("Consider replacing `%1$s` with `%2$s:%3$s=\"%4$s\"` to better support right-to-left layouts", attribute.getName(), attribute.getPrefix(), rtl, value) : String.format("Consider adding `%1$s:%2$s=\"%3$s\"` to better support right-to-left layouts", attribute.getPrefix(), rtl, value);
                context.report(USE_START, (org.w3c.dom.Node)attribute, context.getNameLocation((org.w3c.dom.Node)attribute), message);
            }
        } else {
            if (project.getMinSdk() >= 17 || !context.isEnabled(COMPAT)) {
                return;
            }
            int folderVersion = context.getFolderVersion();
            if (folderVersion >= 17) {
                return;
            }
            String old = RtlDetector.convertNewToOld(name);
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", old)) {
                return;
            }
            String message = String.format("To support older versions than API 17 (project specifies %1$d) you should *also* add `%2$s:%3$s=\"%4$s\"`", project.getMinSdk(), attribute.getPrefix(), old, RtlDetector.convertNewToOld(value));
            context.report(COMPAT, (org.w3c.dom.Node)attribute, context.getNameLocation((org.w3c.dom.Node)attribute), message);
        }
    }

    private static boolean isOldAttribute(String name) {
        return name.contains(LEFT) || name.contains(RIGHT);
    }

    private static boolean isMarginAttribute(String name) {
        return name.startsWith("layout_margin");
    }

    private static boolean isPaddingAttribute(String name) {
        return name.startsWith("padding");
    }

    public boolean appliesTo(Context context, File file) {
        return true;
    }

    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(Identifier.class);
    }

    public AstVisitor createJavaVisitor(JavaContext context) {
        if (this.rtlApplies((Context)context)) {
            return new IdentifierChecker(context);
        }
        return new ForwardingAstVisitor(){};
    }

    static {
        if (LintUtils.assertionsEnabled()) {
            for (int i = 0; i < ATTRIBUTES.length; i += 2) {
                String replace = ATTRIBUTES[i];
                String with = ATTRIBUTES[i + 1];
                assert (with.equals(RtlDetector.convertOldToNew(replace)));
                assert (replace.equals(RtlDetector.convertNewToOld(with)));
            }
        }
    }

    private static class IdentifierChecker
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public IdentifierChecker(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitIdentifier(Identifier node) {
            String identifier = node.astValue();
            boolean isLeft = RtlDetector.LEFT_FIELD.equals(identifier);
            boolean isRight = RtlDetector.RIGHT_FIELD.equals(identifier);
            if (!isLeft && !isRight) {
                return false;
            }
            Node parent = node.getParent();
            if (parent instanceof ImportDeclaration || parent instanceof EnumConstant || parent instanceof VariableDefinitionEntry) {
                return false;
            }
            JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)node);
            if (resolved != null) {
                if (!(resolved instanceof JavaParser.ResolvedField)) {
                    return false;
                }
                JavaParser.ResolvedField field = (JavaParser.ResolvedField)resolved;
                JavaParser.ResolvedClass containingClass = field.getContainingClass();
                if (containingClass == null || !containingClass.matches(RtlDetector.FQCN_GRAVITY)) {
                    return false;
                }
            } else {
                if (parent instanceof Select && !RtlDetector.GRAVITY_CLASS.equals(((Select)parent).astOperand().toString())) {
                    return false;
                }
                if (parent instanceof VariableReference && !LintUtils.isImported((Node)this.mContext.getCompilationUnit(), (String)(RtlDetector.FQCN_GRAVITY_PREFIX + identifier))) {
                    return false;
                }
            }
            String message = String.format("Use \"`Gravity.%1$s`\" instead of \"`Gravity.%2$s`\" to ensure correct behavior in right-to-left locales", (isLeft ? "start" : "end").toUpperCase(Locale.US), (isLeft ? "left" : "right").toUpperCase(Locale.US));
            Location location = this.mContext.getLocation((Node)node);
            this.mContext.report(USE_START, (Node)node, location, message);
            return true;
        }
    }
}

