/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiPackage;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ApiParser
extends DefaultHandler {
    private static final String NODE_API = "api";
    private static final String NODE_CLASS = "class";
    private static final String NODE_FIELD = "field";
    private static final String NODE_METHOD = "method";
    private static final String NODE_EXTENDS = "extends";
    private static final String NODE_IMPLEMENTS = "implements";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SINCE = "since";
    private static final String ATTR_DEPRECATED = "deprecated";
    private final Map<String, ApiClass> mClasses = new HashMap<String, ApiClass>(1000);
    private final Map<String, ApiPackage> mPackages = new HashMap<String, ApiPackage>();
    private ApiClass mCurrentClass;

    ApiParser() {
    }

    Map<String, ApiClass> getClasses() {
        return this.mClasses;
    }

    Map<String, ApiPackage> getPackages() {
        return this.mPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName == null || localName.isEmpty()) {
            localName = qName;
        }
        try {
            if (NODE_API.equals(localName)) {
            } else if (NODE_CLASS.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = Integer.parseInt(attributes.getValue(ATTR_SINCE));
                String deprecatedAttr = attributes.getValue(ATTR_DEPRECATED);
                int deprecatedIn = deprecatedAttr != null ? Integer.parseInt(deprecatedAttr) : 0;
                this.mCurrentClass = this.addClass(name, since, deprecatedIn);
            } else if (NODE_EXTENDS.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                this.mCurrentClass.addSuperClass(name, since);
            } else if (NODE_IMPLEMENTS.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                this.mCurrentClass.addInterface(name, since);
            } else if (NODE_METHOD.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                int deprecatedIn = this.getDeprecatedIn(attributes);
                this.mCurrentClass.addMethod(name, since, deprecatedIn);
            } else if (NODE_FIELD.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                int deprecatedIn = this.getDeprecatedIn(attributes);
                this.mCurrentClass.addField(name, since, deprecatedIn);
            }
        }
        finally {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    private ApiClass addClass(String name, int apiLevel, int deprecatedIn) {
        ApiClass theClass = this.mClasses.get(name);
        assert (theClass == null);
        theClass = new ApiClass(name, apiLevel, deprecatedIn);
        this.mClasses.put(name, theClass);
        String pkg = theClass.getPackage();
        if (pkg != null) {
            ApiPackage apiPackage = this.mPackages.get(pkg);
            if (apiPackage == null) {
                apiPackage = new ApiPackage(pkg);
                this.mPackages.put(pkg, apiPackage);
            }
            apiPackage.addClass(theClass);
        }
        return theClass;
    }

    private int getSince(Attributes attributes) {
        int since = this.mCurrentClass.getSince();
        String sinceAttr = attributes.getValue(ATTR_SINCE);
        if (sinceAttr != null) {
            since = Integer.parseInt(sinceAttr);
        }
        return since;
    }

    private int getDeprecatedIn(Attributes attributes) {
        int deprecatedIn = this.mCurrentClass.getDeprecatedIn();
        String deprecatedAttr = attributes.getValue(ATTR_DEPRECATED);
        if (deprecatedAttr != null) {
            deprecatedIn = Integer.parseInt(deprecatedAttr);
        }
        return deprecatedIn;
    }
}

