/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.Node;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PrivateResourceDetector
extends ResourceXmlDetector
implements Detector.JavaScanner {
    private static final String ATTR_OVERRIDE = "override";
    private static final Implementation IMPLEMENTATION = new Implementation(PrivateResourceDetector.class, Scope.JAVA_AND_RESOURCE_FILES, new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE});
    public static final Issue ISSUE = Issue.create((String)"PrivateResource", (String)"Using private resources", (String)"Private resources should not be referenced; the may not be present everywhere, and even where they are they may disappear without notice.\n\nTo fix this, copy the resource into your own project instead.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public boolean appliesToResourceRefs() {
        return true;
    }

    public void visitResourceReference(JavaContext context, AstVisitor visitor, Node node, String type, String name, boolean isFramework) {
        ResourceType resourceType;
        Project project;
        if (context.getProject().isGradleProject() && !isFramework && (project = context.getProject()).getGradleProjectModel() != null && project.getCurrentVariant() != null && (resourceType = ResourceType.getEnum((String)type)) != null && PrivateResourceDetector.isPrivate((Context)context, resourceType, name)) {
            String message = PrivateResourceDetector.createUsageErrorMessage((Context)context, resourceType, name);
            context.report(ISSUE, node, context.getLocation(node), message);
        }
    }

    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        ResourceUrl url;
        String value = attribute.getNodeValue();
        if (context.getProject().isGradleProject() && PrivateResourceDetector.isPrivate((Context)context, url = ResourceUrl.parse((String)value))) {
            String message = PrivateResourceDetector.createUsageErrorMessage((Context)context, url.type, url.name);
            context.report(ISSUE, (org.w3c.dom.Node)attribute, context.getValueLocation(attribute), message);
        }
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("style", "resources", "array", "string-array", "integer-array", "plurals");
    }

    public void visitElement(XmlContext context, Element element) {
        if ("resources".equals(element.getTagName())) {
            for (Element item : LintUtils.getChildren((org.w3c.dom.Node)element)) {
                ResourceType t;
                Attr nameAttribute = item.getAttributeNode("name");
                if (nameAttribute == null) continue;
                String name = SdkUtils.getResourceFieldName((String)nameAttribute.getValue());
                String type = item.getTagName();
                if (type.equals("item")) {
                    type = item.getAttribute("type");
                    if (type == null || type.isEmpty()) {
                        type = "id";
                    }
                } else if (type.equals("declare-styleable")) {
                    type = "styleable";
                } else if (type.contains("array")) {
                    type = "array";
                }
                if ((t = ResourceType.getEnum((String)type)) == null || !PrivateResourceDetector.isPrivate((Context)context, t, name) || "true".equals(item.getAttributeNS("http://schemas.android.com/tools", ATTR_OVERRIDE))) continue;
                String message = PrivateResourceDetector.createOverrideErrorMessage((Context)context, t, name);
                Location location = context.getValueLocation(nameAttribute);
                context.report(ISSUE, (org.w3c.dom.Node)nameAttribute, location, message);
            }
        } else {
            assert ("style".equals(element.getTagName()) || "array".equals(element.getTagName()) || "plurals".equals(element.getTagName()) || "integer-array".equals(element.getTagName()) || "string-array".equals(element.getTagName()));
            for (Element item : LintUtils.getChildren((org.w3c.dom.Node)element)) {
                PrivateResourceDetector.checkChildRefs(context, item);
            }
        }
    }

    private static boolean isPrivate(Context context, ResourceType type, String name) {
        if (type == ResourceType.ID) {
            return false;
        }
        if (context.getProject().isGradleProject()) {
            ResourceVisibilityLookup lookup = context.getProject().getResourceVisibility();
            return lookup.isPrivate(type, name);
        }
        return false;
    }

    private static boolean isPrivate(Context context, ResourceUrl url) {
        return url != null && !url.framework && PrivateResourceDetector.isPrivate(context, url.type, url.name);
    }

    private static void checkChildRefs(XmlContext context, Element item) {
        NodeList childNodes = item.getChildNodes();
        int n = childNodes.getLength();
        block0: for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node child = childNodes.item(i);
            if (child.getNodeType() != 3) continue;
            String text = child.getNodeValue();
            int index = text.indexOf("?attr/");
            if (index != -1) {
                String name = text.substring(index + "?attr/".length()).trim();
                if (!PrivateResourceDetector.isPrivate((Context)context, ResourceType.ATTR, name)) continue;
                String message = PrivateResourceDetector.createUsageErrorMessage((Context)context, ResourceType.ATTR, name);
                context.report(ISSUE, (org.w3c.dom.Node)item, context.getLocation(child), message);
                continue;
            }
            int m = text.length();
            for (int j = 0; j < m; ++j) {
                char c = text.charAt(j);
                if (c == '@') {
                    ResourceUrl url = ResourceUrl.parse((String)text.trim());
                    if (!PrivateResourceDetector.isPrivate((Context)context, url)) continue block0;
                    String message = PrivateResourceDetector.createUsageErrorMessage((Context)context, url.type, url.name);
                    context.report(ISSUE, (org.w3c.dom.Node)item, context.getLocation(child), message);
                    continue block0;
                }
                if (!Character.isWhitespace(c)) continue block0;
            }
        }
    }

    public void beforeCheckFile(Context context) {
        String resourceName;
        File file = context.file;
        boolean isXmlFile = LintUtils.isXmlFile((File)file);
        if (!isXmlFile && !LintUtils.isBitmapFile((File)file)) {
            return;
        }
        String parentName = file.getParentFile().getName();
        int dash = parentName.indexOf(45);
        if (dash != -1 || "values".equals(parentName)) {
            return;
        }
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)parentName);
        if (folderType == null) {
            return;
        }
        List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
        if (types.isEmpty()) {
            return;
        }
        ResourceType type = (ResourceType)types.get(0);
        if (PrivateResourceDetector.isPrivate(context, type, resourceName = SdkUtils.getResourceFieldName((String)LintUtils.getBaseName((String)file.getName())))) {
            String message = PrivateResourceDetector.createOverrideErrorMessage(context, type, resourceName);
            Location location = Location.create((File)file);
            context.report(ISSUE, location, message);
        }
    }

    private static String createOverrideErrorMessage(Context context, ResourceType type, String name) {
        String libraryName = PrivateResourceDetector.getLibraryName(context, type, name);
        return String.format("Overriding `@%1$s/%2$s` which is marked as private in %3$s. If deliberate, use tools:override=\"true\", otherwise pick a different name.", type, name, libraryName);
    }

    private static String createUsageErrorMessage(Context context, ResourceType type, String name) {
        String libraryName = PrivateResourceDetector.getLibraryName(context, type, name);
        return String.format("The resource `@%1$s/%2$s` is marked as private in %3$s", type, name, libraryName);
    }

    private static String getLibraryName(Context context, ResourceType type, String name) {
        ResourceVisibilityLookup lookup = context.getProject().getResourceVisibility();
        AndroidLibrary library = lookup.getPrivateIn(type, name);
        if (library != null) {
            String libraryName = library.getProject();
            if (libraryName != null) {
                return libraryName;
            }
            MavenCoordinates coordinates = library.getResolvedCoordinates();
            if (coordinates != null) {
                return coordinates.getGroupId() + ':' + coordinates.getArtifactId();
            }
        }
        return "the library";
    }
}

