/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;

@BugPattern(name="LockOnBoxedPrimitive", summary="It is dangerous to use a boxed primitive as a lock as it can unintentionally lead to sharing a lock with another piece of code.", explanation="Instances of boxed primitive types may be cached by the standard library `valueOf` method. This method is used for autoboxing. This means that using a boxed primitive as a lock can result in unintentionally sharing a lock with another piece of code.", severity=BugPattern.SeverityLevel.WARNING)
public class LockOnBoxedPrimitive
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher,
BugChecker.SynchronizedTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<AssignmentTree> PRIMITIVE_TO_OBJECT_ASSIGNMENT = Matchers.assignment((Matcher)Matchers.anything(), (Matcher)Matchers.isPrimitiveOrBoxedPrimitiveType());
    private static final Matcher<VariableTree> PRIMITIVE_TO_OBJECT_INITIALIZER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anything(), Matchers.variableInitializer((Matcher)Matchers.isPrimitiveOrBoxedPrimitiveType())});
    private static final Matcher<ExpressionTree> LOCKING_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().anyClass().named("wait").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.LONG_TYPE)), Matchers.instanceMethod().anyClass().named("wait").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.LONG_TYPE, (Object)Suppliers.INT_TYPE)), Matchers.instanceMethod().anyClass().namedAnyOf(new String[]{"wait", "notify", "notifyAll"}).withParameters(new String[0])});
    private static final Matcher<ExpressionTree> BOXED_PRIMITIVE = Matchers.isBoxedPrimitiveType();
    private ImmutableSet<Symbol> knownBoxedVariables;

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        this.knownBoxedVariables = LockOnBoxedPrimitive.getKnownEncapsulatedBoxedObjects(tree, state);
        return Description.NO_MATCH;
    }

    public Description matchSynchronized(SynchronizedTree tree, VisitorState state) {
        if (this.isDefinitelyBoxedPrimitive(tree.getExpression(), state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (LOCKING_METHOD.matches((Tree)tree, state) && this.isDefinitelyBoxedPrimitive(ASTHelpers.getReceiver((ExpressionTree)tree), state)) {
            return this.describeMatch(tree.getMethodSelect());
        }
        return Description.NO_MATCH;
    }

    private boolean isDefinitelyBoxedPrimitive(ExpressionTree tree, VisitorState state) {
        ExpressionTree stripped = ASTHelpers.stripParentheses((ExpressionTree)tree);
        return BOXED_PRIMITIVE.matches((Tree)stripped, state) || this.isKnownBoxedSymbol(stripped);
    }

    private boolean isKnownBoxedSymbol(ExpressionTree tree) {
        return this.knownBoxedVariables.contains((Object)ASTHelpers.getSymbol((Tree)tree));
    }

    private static ImmutableSet<Symbol> getKnownEncapsulatedBoxedObjects(CompilationUnitTree compilationUnitTree, final VisitorState state) {
        final ImmutableSet.Builder knownBoxedVariables = ImmutableSet.builder();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitAssignment(AssignmentTree assignmentTree, Void unused) {
                if (PRIMITIVE_TO_OBJECT_ASSIGNMENT.matches((Tree)assignmentTree, state)) {
                    Optional.ofNullable(ASTHelpers.getSymbol((Tree)assignmentTree.getVariable())).ifPresent(arg_0 -> ((ImmutableSet.Builder)knownBoxedVariables).add(arg_0));
                }
                return (Void)super.visitAssignment(assignmentTree, null);
            }

            @Override
            public Void visitVariable(VariableTree variableTree, Void unused) {
                if (PRIMITIVE_TO_OBJECT_INITIALIZER.matches((Tree)variableTree, state)) {
                    Optional.ofNullable(ASTHelpers.getSymbol((VariableTree)variableTree)).ifPresent(arg_0 -> ((ImmutableSet.Builder)knownBoxedVariables).add(arg_0));
                }
                return (Void)super.visitVariable(variableTree, null);
            }
        }.scan(compilationUnitTree, null);
        return knownBoxedVariables.build();
    }
}

