/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.Tree;

@BugPattern(name="NullTernary", summary="This conditional expression may evaluate to null, which will result in an NPE when the result is unboxed.", severity=BugPattern.SeverityLevel.ERROR)
public class NullTernary
extends BugChecker
implements BugChecker.ConditionalExpressionTreeMatcher {
    public Description matchConditionalExpression(ConditionalExpressionTree conditionalExpression, VisitorState state) {
        if (conditionalExpression.getFalseExpression().getKind() != Tree.Kind.NULL_LITERAL && conditionalExpression.getTrueExpression().getKind() != Tree.Kind.NULL_LITERAL) {
            return Description.NO_MATCH;
        }
        ASTHelpers.TargetType targetType = ASTHelpers.targetType((VisitorState)state);
        if (targetType == null || !targetType.type().isPrimitive()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(conditionalExpression);
    }
}

