/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableAnalysis;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafety;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;
import java.util.stream.Stream;

@BugPattern(name="ImmutableEnumChecker", altNames={"Immutable"}, summary="Enums should always be immutable", severity=BugPattern.SeverityLevel.WARNING)
public class ImmutableEnumChecker
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public static final String ANNOTATED_ENUM_MESSAGE = "enums are immutable by default; annotating them with @com.google.errorprone.annotations.Immutable is unnecessary";
    private final WellKnownMutability wellKnownMutability;

    @Deprecated
    public ImmutableEnumChecker() {
        this(ErrorProneFlags.empty());
    }

    public ImmutableEnumChecker(ErrorProneFlags flags) {
        this.wellKnownMutability = WellKnownMutability.fromFlags(flags);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        ThreadSafety.Violation info;
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)tree);
        if (symbol == null || !symbol.isEnum()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Symbol)symbol, Immutable.class, (VisitorState)state) && !ImmutableEnumChecker.implementsImmutableInterface(symbol)) {
            AnnotationTree annotation = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"Immutable");
            if (annotation != null) {
                state.reportMatch(this.buildDescription(annotation).setMessage(ANNOTATED_ENUM_MESSAGE).addFix((Fix)SuggestedFix.delete((Tree)annotation)).build());
            } else {
                state.reportMatch(this.buildDescription(tree).setMessage(ANNOTATED_ENUM_MESSAGE).build());
            }
        }
        if (!(info = new ImmutableAnalysis(this, state, this.wellKnownMutability, (ImmutableSet<String>)ImmutableSet.of((Object)Immutable.class.getName())).checkForImmutability(Optional.of(tree), (ImmutableSet<String>)ImmutableSet.of(), ASTHelpers.getType((ClassTree)tree), this::describe)).isPresent()) {
            return Description.NO_MATCH;
        }
        return this.describe(tree, info).build();
    }

    private Description.Builder describe(Tree tree, ThreadSafety.Violation info) {
        String message = "enums should be immutable: " + info.message();
        return this.buildDescription(tree).setMessage(message);
    }

    private static boolean implementsImmutableInterface(Symbol.ClassSymbol symbol) {
        return Streams.concat((Stream[])new Stream[]{symbol.getInterfaces().stream(), Stream.of(symbol.getSuperclass())}).anyMatch(supertype -> supertype.asElement().getAnnotation(Immutable.class) != null);
    }
}

