/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg.block;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.cfg.block.Block;
import org.checkerframework.shaded.dataflow.cfg.block.BlockImpl;
import org.checkerframework.shaded.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.shaded.javacutil.BugInCF;

public class ConditionalBlockImpl
extends BlockImpl
implements ConditionalBlock {
    protected @Nullable BlockImpl thenSuccessor;
    protected @Nullable BlockImpl elseSuccessor;
    protected Store.FlowRule thenFlowRule = Store.FlowRule.THEN_TO_BOTH;
    protected Store.FlowRule elseFlowRule = Store.FlowRule.ELSE_TO_BOTH;

    public ConditionalBlockImpl() {
        super(Block.BlockType.CONDITIONAL_BLOCK);
    }

    public void setThenSuccessor(BlockImpl b) {
        this.thenSuccessor = b;
        b.addPredecessor(this);
    }

    public void setElseSuccessor(BlockImpl b) {
        this.elseSuccessor = b;
        b.addPredecessor(this);
    }

    @Override
    public Block getThenSuccessor() {
        if (this.thenSuccessor == null) {
            throw new BugInCF("Requested thenSuccessor for conditional block before initialization");
        }
        return this.thenSuccessor;
    }

    @Override
    public Block getElseSuccessor() {
        if (this.elseSuccessor == null) {
            throw new BugInCF("Requested elseSuccessor for conditional block before initialization");
        }
        return this.elseSuccessor;
    }

    @Override
    public Store.FlowRule getThenFlowRule() {
        return this.thenFlowRule;
    }

    @Override
    public Store.FlowRule getElseFlowRule() {
        return this.elseFlowRule;
    }

    @Override
    public void setThenFlowRule(Store.FlowRule rule) {
        this.thenFlowRule = rule;
    }

    @Override
    public void setElseFlowRule(Store.FlowRule rule) {
        this.elseFlowRule = rule;
    }

    public String toString() {
        return "ConditionalBlock()";
    }
}

