/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.apidiff;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.bugpatterns.apidiff.ApiDiff;
import com.google.errorprone.bugpatterns.apidiff.ApiDiffChecker;
import com.google.errorprone.bugpatterns.apidiff.Java7ApiChecker;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@BugPattern(name="AndroidJdkLibsChecker", altNames={"Java7ApiChecker", "AndroidApiChecker"}, summary="Use of class, field, or method that is not compatible with legacy Android devices", severity=BugPattern.SeverityLevel.ERROR)
public class AndroidJdkLibsChecker
extends ApiDiffChecker {
    public AndroidJdkLibsChecker(ErrorProneFlags flags) {
        this(flags.getBoolean("Android:Java8Libs").orElse(false));
    }

    public AndroidJdkLibsChecker() {
        this(false);
    }

    private AndroidJdkLibsChecker(boolean allowJava8) {
        super(AndroidJdkLibsChecker.deriveApiDiff(allowJava8));
    }

    private static ApiDiff deriveApiDiff(boolean allowJava8) {
        ClassSupportInfo support = new ClassSupportInfo(allowJava8);
        ImmutableSet unsupportedClasses = ImmutableSet.builder().addAll((Iterable)Java7ApiChecker.API_DIFF.unsupportedClasses().stream().filter(cls -> !support.allowedPackages.contains((Object)AndroidJdkLibsChecker.packageName(cls))).filter(cls -> !support.allowedClasses.contains(cls)).collect(Collectors.toSet())).addAll((Iterable)support.bannedClasses).build();
        ImmutableSetMultimap unsupportedMembers = ImmutableSetMultimap.builder().putAll((Iterable)Java7ApiChecker.API_DIFF.unsupportedMembersByClass().entries().stream().filter(e -> !support.allowedPackages.contains((Object)AndroidJdkLibsChecker.packageName((String)e.getKey()))).filter(e -> !support.allowedClasses.contains(e.getKey())).filter(e -> support.bannedMembers.isEmpty() || !support.memberIsWhitelisted(e)).collect(Collectors.toSet())).putAll((Multimap)support.bannedMembers).build();
        return ApiDiff.fromMembers((Set<String>)unsupportedClasses, (Multimap<String, ApiDiff.ClassMemberKey>)unsupportedMembers);
    }

    private static String packageName(String className) {
        return className.substring(0, className.lastIndexOf(47) + 1);
    }

    private static class ClassSupportInfo {
        private final ImmutableSet<String> allowedPackages;
        private final ImmutableSet<String> allowedClasses;
        private final ImmutableSet<String> bannedClasses;
        private final ImmutableSetMultimap<String, ApiDiff.ClassMemberKey> allowedMembers;
        private final ImmutableSetMultimap<String, ApiDiff.ClassMemberKey> bannedMembers;
        private static final ImmutableSet<String> DESUGAR_ALLOWED_PACKAGES = ImmutableSet.of((Object)"java/time/", (Object)"java/time/chrono/", (Object)"java/time/temporal/", (Object)"java/time/zone/", (Object)"java/util/stream/", (Object)"java/util/function/", (Object[])new String[0]);
        private static final ImmutableSet<String> BASE_ALLOWED_CLASSES = ImmutableSet.of((Object)"java/lang/annotation/Repeatable", (Object)"java/lang/annotation/ElementType");
        private static final ImmutableSet<String> DESUGAR_ALLOWED_CLASSES = ImmutableSet.builder().addAll(BASE_ALLOWED_CLASSES).add((Object)"java/io/UncheckedIOException").add((Object)"java/util/ArrayList").add((Object)"java/util/Collection").add((Object)"java/util/Comparator").add((Object)"java/util/DoubleSummaryStatistics").add((Object)"java/util/IntSummaryStatistics").add((Object)"java/util/Iterator").add((Object)"java/util/List").add((Object)"java/util/LongSummaryStatistics").add((Object)"java/util/Map").add((Object)"java/util/Map\\$$Entry").add((Object)"java/util/Objects").add((Object)"java/util/Optional").add((Object)"java/util/OptionalDouble").add((Object)"java/util/OptionalInt").add((Object)"java/util/OptionalLong").add((Object)"java/util/PrimitiveIterator").add((Object)"java/util/Set").add((Object)"java/util/Spliterator").add((Object)"java/util/Spliterator$OfDouble").add((Object)"java/util/Spliterator$OfInt").add((Object)"java/util/Spliterator$OfLong").add((Object)"java/util/Spliterator$OfPrimitive").add((Object)"java/util/StringJoiner").add((Object)"java/util/concurrent/ConcurrentMap").add((Object)"java/util/concurrent/atomic/AtomicInteger").add((Object)"java/util/concurrent/atomic/AtomicLong").add((Object)"java/util/concurrent/atomic/AtomicReference").build();
        private static final ImmutableSet<String> BASE_BANNED_CLASSES = ImmutableSet.of((Object)"javax/lang/model/type/TypeKind");
        private static final ImmutableSetMultimap<String, ApiDiff.ClassMemberKey> DESUGAR_ALLOWED_MEMBERS = ImmutableSetMultimap.builder().put((Object)"java/util/Arrays", (Object)ApiDiff.ClassMemberKey.create("stream", "")).put((Object)"java/util/Date", (Object)ApiDiff.ClassMemberKey.create("from", "")).put((Object)"java/util/GregorianCalendar", (Object)ApiDiff.ClassMemberKey.create("from", "")).put((Object)"java/util/TimeZone", (Object)ApiDiff.ClassMemberKey.create("getTimeZone", "")).put((Object)"java/lang/Integer", (Object)ApiDiff.ClassMemberKey.create("sum", "")).put((Object)"java/lang/Long", (Object)ApiDiff.ClassMemberKey.create("sum", "")).put((Object)"java/lang/Double", (Object)ApiDiff.ClassMemberKey.create("sum", "")).put((Object)"java/lang/Integer", (Object)ApiDiff.ClassMemberKey.create("min", "")).put((Object)"java/lang/Long", (Object)ApiDiff.ClassMemberKey.create("min", "")).put((Object)"java/lang/Double", (Object)ApiDiff.ClassMemberKey.create("min", "")).put((Object)"java/lang/Integer", (Object)ApiDiff.ClassMemberKey.create("max", "")).put((Object)"java/lang/Long", (Object)ApiDiff.ClassMemberKey.create("max", "")).put((Object)"java/lang/Double", (Object)ApiDiff.ClassMemberKey.create("max", "")).put((Object)"java/lang/Math", (Object)ApiDiff.ClassMemberKey.create("toIntExact", "")).build();
        private static final ImmutableSetMultimap<String, ApiDiff.ClassMemberKey> DESUGAR_BANNED_MEMBERS = ImmutableSetMultimap.builder().put((Object)"java/util/Collection", (Object)ApiDiff.ClassMemberKey.create("parallelStream", "")).put((Object)"java/util/stream/BaseStream", (Object)ApiDiff.ClassMemberKey.create("parallel", "")).build();

        ClassSupportInfo(boolean allowJava8) {
            this.allowedPackages = allowJava8 ? DESUGAR_ALLOWED_PACKAGES : ImmutableSet.of();
            this.allowedClasses = allowJava8 ? DESUGAR_ALLOWED_CLASSES : BASE_ALLOWED_CLASSES;
            this.bannedClasses = BASE_BANNED_CLASSES;
            this.allowedMembers = allowJava8 ? DESUGAR_ALLOWED_MEMBERS : ImmutableSetMultimap.of();
            this.bannedMembers = allowJava8 ? DESUGAR_BANNED_MEMBERS : ImmutableSetMultimap.of();
        }

        private boolean memberIsWhitelisted(Map.Entry<String, ApiDiff.ClassMemberKey> member) {
            return this.allowedMembers.containsEntry((Object)member.getKey(), (Object)member.getValue()) || this.allowedMembers.get((Object)member.getKey()).stream().anyMatch(memberKey -> memberKey.descriptor().isEmpty() && memberKey.identifier().equals(((ApiDiff.ClassMemberKey)member.getValue()).identifier()));
        }
    }
}

