/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypeCompatibilityUtils;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Type;
import javax.annotation.Nullable;

@BugPattern(name="TruthIncompatibleType", summary="Argument is not compatible with the subject's type.", severity=BugPattern.SeverityLevel.WARNING)
public class TruthIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final AbstractCollectionIncompatibleTypeMatcher MATCHER = new AbstractCollectionIncompatibleTypeMatcher(){
        private final Matcher<ExpressionTree> assertThatObject = MethodMatchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertThat").withParameters(new String[]{"java.lang.Object"});
        public final Matcher<ExpressionTree> isEqualTo = MethodMatchers.instanceMethod().onExactClass("com.google.common.truth.Subject").named("isEqualTo").withParameters(new String[]{"java.lang.Object"});

        @Override
        Matcher<ExpressionTree> methodMatcher() {
            return this.isEqualTo;
        }

        @Override
        @Nullable
        Type extractSourceType(MethodInvocationTree tree, VisitorState state) {
            return ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(tree.getArguments())));
        }

        @Override
        @Nullable
        Type extractSourceType(MemberReferenceTree tree, VisitorState state) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        ExpressionTree extractSourceTree(MethodInvocationTree tree, VisitorState state) {
            return (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        }

        @Override
        @Nullable
        ExpressionTree extractSourceTree(MemberReferenceTree tree, VisitorState state) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        Type extractTargetType(MethodInvocationTree tree, VisitorState state) {
            ExpressionTree curr = tree;
            while (curr instanceof MethodInvocationTree) {
                if (this.assertThatObject.matches((Tree)curr, state)) {
                    return ASTHelpers.getType((Tree)((ExpressionTree)Iterables.getOnlyElement(curr.getArguments())).accept(new SimpleTreeVisitor<Tree, Void>(){

                        @Override
                        protected Tree defaultAction(Tree node, Void unused) {
                            return node;
                        }

                        @Override
                        public Tree visitTypeCast(TypeCastTree node, Void unused) {
                            return node.getExpression().accept(this, null);
                        }

                        @Override
                        public Tree visitParenthesized(ParenthesizedTree node, Void unused) {
                            return node.getExpression().accept(this, null);
                        }
                    }, null));
                }
                curr = ASTHelpers.getReceiver((ExpressionTree)curr);
            }
            return null;
        }

        @Override
        @Nullable
        Type extractTargetType(MemberReferenceTree tree, VisitorState state) {
            throw new UnsupportedOperationException();
        }
    };

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        String targetType;
        AbstractCollectionIncompatibleTypeMatcher.MatchResult result = MATCHER.matches(tree, state);
        if (result == null) {
            return Description.NO_MATCH;
        }
        TypeCompatibilityUtils.TypeCompatibilityReport compatibilityReport = TypeCompatibilityUtils.compatibilityOfTypes(result.targetType(), result.sourceType(), state);
        if (compatibilityReport.compatible()) {
            return Description.NO_MATCH;
        }
        String sourceType = Signatures.prettyType((Type)result.sourceType());
        if (sourceType.equals(targetType = Signatures.prettyType((Type)result.targetType()))) {
            sourceType = result.sourceType().toString();
            targetType = result.targetType().toString();
        }
        Description.Builder description = this.buildDescription(tree);
        description.setMessage(result.message(sourceType, targetType));
        return description.build();
    }
}

