/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation;

import com.google.monitoring.runtime.instrumentation.asm.ClassReader;
import com.google.monitoring.runtime.instrumentation.asm.ClassWriter;
import com.google.monitoring.runtime.instrumentation.asm.Type;
import java.io.IOException;
import java.io.InputStream;

public class StaticClassWriter
extends ClassWriter {
    private final ClassLoader classLoader;
    private boolean alwaysStatic;

    public StaticClassWriter(ClassReader classReader, int flags, ClassLoader classLoader) {
        super(classReader, flags);
        this.classLoader = classLoader;
        this.alwaysStatic = false;
    }

    public StaticClassWriter(ClassReader classReader, int flags, ClassLoader classLoader, boolean alwaysStatic) {
        super(classReader, flags);
        this.classLoader = classLoader;
        this.alwaysStatic = alwaysStatic;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        ClassInfo ci2;
        ClassInfo ci1;
        if (!this.alwaysStatic) {
            try {
                return super.getCommonSuperClass(type1, type2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            ci1 = new ClassInfo(type1, this.classLoader, this.alwaysStatic);
            ci2 = new ClassInfo(type2, this.classLoader, this.alwaysStatic);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (ci1.isAssignableFrom(ci2)) {
            return type1;
        }
        if (ci2.isAssignableFrom(ci1)) {
            return type2;
        }
        if (ci1.isInterface() || ci2.isInterface()) {
            return "java/lang/Object";
        }
        while (!(ci1 = ci1.getSuperclass()).isAssignableFrom(ci2)) {
        }
        return ci1.getType().getInternalName();
    }

    static class ClassInfo {
        private final Type type;
        private final ClassLoader loader;
        private final boolean isInterface;
        private final String superClass;
        private final String[] interfaces;
        private final boolean alwaysStatic;

        public ClassInfo(String type, ClassLoader loader, boolean alwaysStatic) {
            ClassReader cr;
            this.alwaysStatic = alwaysStatic;
            if (!alwaysStatic) {
                Class<?> cls = null;
                try {
                    cls = Class.forName(type);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (cls != null) {
                    this.type = Type.getType(cls);
                    this.loader = loader;
                    this.isInterface = cls.isInterface();
                    this.superClass = cls.getSuperclass().getName();
                    Class<?>[] ifs = cls.getInterfaces();
                    this.interfaces = new String[ifs.length];
                    for (int i = 0; i < ifs.length; ++i) {
                        this.interfaces[i] = ifs[i].getName();
                    }
                    return;
                }
            }
            this.loader = loader;
            this.type = Type.getObjectType(type);
            String fileName = type.replace('.', '/') + ".class";
            InputStream is = null;
            try {
                is = loader == null ? ClassLoader.getSystemResourceAsStream(fileName) : loader.getResourceAsStream(fileName);
                cr = new ClassReader(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading: " + fileName, e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            int offset = cr.header;
            this.isInterface = (cr.readUnsignedShort(offset) & 0x200) != 0;
            char[] buf = new char[2048];
            this.superClass = this.readConstantPoolString(cr, offset += 4, buf);
            int numInterfaces = cr.readUnsignedShort(offset += 2);
            this.interfaces = new String[numInterfaces];
            offset += 2;
            for (int i = 0; i < numInterfaces; ++i) {
                this.interfaces[i] = this.readConstantPoolString(cr, offset, buf);
                offset += 2;
            }
        }

        String readConstantPoolString(ClassReader cr, int offset, char[] buf) {
            int cpIndex = cr.getItem(cr.readUnsignedShort(offset));
            if (cpIndex == 0) {
                return null;
            }
            return cr.readUTF8(cpIndex, buf);
        }

        Type getType() {
            return this.type;
        }

        ClassInfo getSuperclass() {
            if (this.superClass == null) {
                return null;
            }
            return new ClassInfo(this.superClass, this.loader, this.alwaysStatic);
        }

        ClassInfo[] getInterfaces() {
            if (this.interfaces == null) {
                return new ClassInfo[0];
            }
            ClassInfo[] result = new ClassInfo[this.interfaces.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new ClassInfo(this.interfaces[i], this.loader, this.alwaysStatic);
            }
            return result;
        }

        boolean isInterface() {
            return this.isInterface;
        }

        private boolean implementsInterface(ClassInfo that) {
            for (ClassInfo c = this; c != null; c = c.getSuperclass()) {
                for (ClassInfo iface : c.getInterfaces()) {
                    if (!iface.type.equals(that.type) && !iface.implementsInterface(that)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isSubclassOf(ClassInfo that) {
            for (ClassInfo ci = this; ci != null; ci = ci.getSuperclass()) {
                if (ci.getSuperclass() == null || !ci.getSuperclass().type.equals(that.type)) continue;
                return true;
            }
            return false;
        }

        boolean isAssignableFrom(ClassInfo that) {
            return this == that || that.isSubclassOf(this) || that.implementsInterface(this) || that.isInterface() && this.getType().getDescriptor().equals("Ljava/lang/Object;");
        }
    }
}

