/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.parse;

import com.google.errorprone.annotations.CheckReturnValue;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;

public class UnicodeEscapePreprocessor {
    public static final char ASCII_SUB = '\u001a';
    private final SourceFile source;
    private final String input;
    private int idx = 0;
    private char ch;
    private boolean evenLeadingSlashes = true;

    public UnicodeEscapePreprocessor(SourceFile source) {
        this.source = source;
        this.input = source.source();
    }

    public int position() {
        return this.idx - 1;
    }

    public boolean done() {
        return this.idx >= this.input.length();
    }

    public char next() {
        this.eat();
        if (this.ch == '\\' && this.evenLeadingSlashes) {
            this.unicodeEscape();
        } else {
            this.evenLeadingSlashes = true;
        }
        return this.ch;
    }

    public String readString(int from, int to) {
        return this.input.substring(from, to);
    }

    private void unicodeEscape() {
        this.eat();
        if (this.ch != 'u') {
            --this.idx;
            this.ch = (char)92;
            this.evenLeadingSlashes = false;
            return;
        }
        do {
            this.eat();
        } while (this.ch == 'u');
        char acc = (char)((this.hexDigit(this.ch) & 0xFF) << 12);
        this.eat();
        acc = (char)(acc | (char)((this.hexDigit(this.ch) & 0xFF) << 8));
        this.eat();
        acc = (char)(acc | (char)((this.hexDigit(this.ch) & 0xFF) << 4));
        this.eat();
        this.ch = acc = (char)(acc | (char)(this.hexDigit(this.ch) & 0xFF));
        this.evenLeadingSlashes = this.ch != '\\';
    }

    private int hexDigit(char d) {
        switch (d) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return d - 48;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return d - 65 + 10;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return d - 97 + 10;
            }
            case '\u001a': {
                throw this.error(TurbineError.ErrorKind.UNEXPECTED_EOF, new Object[0]);
            }
        }
        throw this.error(TurbineError.ErrorKind.INVALID_UNICODE, new Object[0]);
    }

    private void eat() {
        this.ch = (char)(this.done() ? 26 : (int)this.input.charAt(this.idx));
        ++this.idx;
    }

    public SourceFile source() {
        return this.source;
    }

    @CheckReturnValue
    private TurbineError error(TurbineError.ErrorKind kind, Object ... args) {
        throw TurbineError.format(this.source(), Math.min(this.position(), this.source().source().length() - 1), kind, args);
    }
}

