/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.lower;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.DisambiguateTypeAnnotations;
import com.google.turbine.binder.bound.EnumConstantValue;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.bound.SourceModuleInfo;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TurbineAnnotationValue;
import com.google.turbine.binder.bound.TurbineClassValue;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ClassWriter;
import com.google.turbine.bytecode.sig.Sig;
import com.google.turbine.bytecode.sig.SigWriter;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.lower.LowerSignature;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.model.TurbineVisibility;
import com.google.turbine.options.LanguageVersion;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import com.google.turbine.types.Erasure;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public class Lower {
    private final LowerSignature sig = new LowerSignature();
    private final Env<ClassSymbol, TypeBoundClass> env;
    private static final int PARAMETER_ACCESS_MASK = 36880;

    public static Lowered lowerAll(LanguageVersion languageVersion, ImmutableMap<ClassSymbol, SourceTypeBoundClass> units, ImmutableList<SourceModuleInfo> modules, Env<ClassSymbol, BytecodeBoundClass> classpath) {
        CompoundEnv<ClassSymbol, TypeBoundClass> env = CompoundEnv.of(classpath).append(new SimpleEnv<ClassSymbol, SourceTypeBoundClass>(units));
        ImmutableMap.Builder result = ImmutableMap.builder();
        LinkedHashSet<ClassSymbol> symbols = new LinkedHashSet<ClassSymbol>();
        int majorVersion = Math.max(languageVersion.majorVersion(), 52);
        for (ClassSymbol sym : units.keySet()) {
            result.put((Object)sym.binaryName(), (Object)Lower.lower((SourceTypeBoundClass)units.get((Object)sym), env, sym, symbols, majorVersion));
        }
        if (modules.size() == 1) {
            result.put((Object)"module-info", (Object)Lower.lower((SourceModuleInfo)Iterables.getOnlyElement(modules), env, symbols, majorVersion));
        } else {
            for (SourceModuleInfo module : modules) {
                result.put((Object)(module.name().replace('.', '/') + "/module-info"), (Object)Lower.lower(module, env, symbols, majorVersion));
            }
        }
        return new Lowered((ImmutableMap<String, byte[]>)result.buildOrThrow(), (ImmutableSet<ClassSymbol>)ImmutableSet.copyOf(symbols));
    }

    public static byte[] lower(SourceTypeBoundClass info, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, Set<ClassSymbol> symbols, int majorVersion) {
        return new Lower(env).lower(info, sym, symbols, majorVersion);
    }

    private static byte[] lower(SourceModuleInfo module, CompoundEnv<ClassSymbol, TypeBoundClass> env, Set<ClassSymbol> symbols, int majorVersion) {
        return new Lower(env).lower(module, symbols, majorVersion);
    }

    public Lower(Env<ClassSymbol, TypeBoundClass> env) {
        this.env = env;
    }

    private byte[] lower(SourceModuleInfo module, Set<ClassSymbol> symbols, int majorVersion) {
        String name = "module-info";
        ImmutableList<ClassFile.AnnotationInfo> annotations = this.lowerAnnotations(module.annos());
        ClassFile.ModuleInfo moduleInfo = this.lowerModule(module);
        ImmutableList.Builder innerClasses = ImmutableList.builder();
        LinkedHashSet<ClassSymbol> all = new LinkedHashSet<ClassSymbol>();
        for (ClassSymbol sym : this.sig.classes) {
            this.addEnclosing(module.source(), this.env, all, sym);
        }
        for (ClassSymbol innerSym : all) {
            innerClasses.add((Object)this.innerClass(this.env, innerSym));
        }
        ClassFile classfile = new ClassFile(32768, majorVersion, name, null, null, (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), (List<ClassFile.MethodInfo>)ImmutableList.of(), (List<ClassFile.FieldInfo>)ImmutableList.of(), (List<ClassFile.AnnotationInfo>)annotations, (List<ClassFile.InnerClass>)innerClasses.build(), (ImmutableList<ClassFile.TypeAnnotationInfo>)ImmutableList.of(), moduleInfo, null, (ImmutableList<String>)ImmutableList.of(), null, null);
        symbols.addAll(this.sig.classes);
        return ClassWriter.writeClass(classfile);
    }

    private ClassFile.ModuleInfo lowerModule(SourceModuleInfo module) {
        ImmutableList.Builder requires = ImmutableList.builder();
        for (ModuleInfo.RequireInfo require : module.requires()) {
            requires.add((Object)new ClassFile.ModuleInfo.RequireInfo(require.moduleName(), require.flags(), require.version()));
        }
        ImmutableList.Builder exports = ImmutableList.builder();
        for (ModuleInfo.ExportInfo export : module.exports()) {
            int exportAccess = 0;
            exports.add((Object)new ClassFile.ModuleInfo.ExportInfo(export.packageName(), exportAccess, export.modules()));
        }
        ImmutableList.Builder opens = ImmutableList.builder();
        for (ModuleInfo.OpenInfo open : module.opens()) {
            int openAccess = 0;
            opens.add((Object)new ClassFile.ModuleInfo.OpenInfo(open.packageName(), openAccess, open.modules()));
        }
        ImmutableList.Builder uses = ImmutableList.builder();
        for (ModuleInfo.UseInfo use : module.uses()) {
            uses.add((Object)new ClassFile.ModuleInfo.UseInfo(this.sig.descriptor(use.sym())));
        }
        ImmutableList.Builder provides = ImmutableList.builder();
        for (ModuleInfo.ProvideInfo provide : module.provides()) {
            ImmutableList.Builder impls = ImmutableList.builder();
            for (ClassSymbol impl : provide.impls()) {
                impls.add((Object)this.sig.descriptor(impl));
            }
            provides.add((Object)new ClassFile.ModuleInfo.ProvideInfo(this.sig.descriptor(provide.sym()), (ImmutableList<String>)impls.build()));
        }
        return new ClassFile.ModuleInfo(module.name(), module.flags(), module.version(), (ImmutableList<ClassFile.ModuleInfo.RequireInfo>)requires.build(), (ImmutableList<ClassFile.ModuleInfo.ExportInfo>)exports.build(), (ImmutableList<ClassFile.ModuleInfo.OpenInfo>)opens.build(), (ImmutableList<ClassFile.ModuleInfo.UseInfo>)uses.build(), (ImmutableList<ClassFile.ModuleInfo.ProvideInfo>)provides.build());
    }

    private byte[] lower(SourceTypeBoundClass info, ClassSymbol sym, Set<ClassSymbol> symbols, int majorVersion) {
        int access = this.classAccess(info);
        String name = this.sig.descriptor(sym);
        String signature = this.sig.classSignature(info, this.env);
        String superName = info.superclass() != null ? this.sig.descriptor(info.superclass()) : null;
        ArrayList<String> interfaces = new ArrayList<String>();
        for (ClassSymbol i : info.interfaces()) {
            interfaces.add(this.sig.descriptor(i));
        }
        ArrayList<String> permits = new ArrayList<String>();
        for (ClassSymbol i : info.permits()) {
            permits.add(this.sig.descriptor(i));
        }
        ClassFile.RecordInfo record = null;
        if (info.kind().equals((Object)TurbineTyKind.RECORD)) {
            ImmutableList.Builder components = ImmutableList.builder();
            for (TypeBoundClass.RecordComponentInfo component : info.components()) {
                components.add((Object)this.lowerComponent(info, component));
            }
            record = new ClassFile.RecordInfo((ImmutableList<ClassFile.RecordInfo.RecordComponentInfo>)components.build());
        }
        ArrayList<ClassFile.MethodInfo> methods = new ArrayList<ClassFile.MethodInfo>();
        for (TypeBoundClass.MethodInfo m : info.methods()) {
            if (TurbineVisibility.fromAccess(m.access()) == TurbineVisibility.PRIVATE) continue;
            methods.add(this.lowerMethod(m, sym));
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        for (TypeBoundClass.FieldInfo f : info.fields()) {
            if ((f.access() & 2) == 2) continue;
            fields.add((Object)this.lowerField(f));
        }
        ImmutableList<ClassFile.AnnotationInfo> annotations = this.lowerAnnotations(info.annotations());
        ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotations = this.classTypeAnnotations(info);
        String nestHost = null;
        ImmutableList nestMembers = ImmutableList.of();
        if (majorVersion >= 55) {
            nestHost = this.collectNestHost(info.source(), info.owner());
            nestMembers = nestHost == null ? this.collectNestMembers(info.source(), info) : ImmutableList.of();
        }
        ImmutableList<ClassFile.InnerClass> inners = this.collectInnerClasses(info.source(), sym, info);
        ClassFile classfile = new ClassFile(access, majorVersion, name, signature, superName, (List<String>)interfaces, (List<String>)permits, (List<ClassFile.MethodInfo>)methods, (List<ClassFile.FieldInfo>)fields.build(), (List<ClassFile.AnnotationInfo>)annotations, (List<ClassFile.InnerClass>)inners, typeAnnotations, null, nestHost, (ImmutableList<String>)nestMembers, record, null);
        symbols.addAll(this.sig.classes);
        return ClassWriter.writeClass(classfile);
    }

    private ClassFile.RecordInfo.RecordComponentInfo lowerComponent(SourceTypeBoundClass info, TypeBoundClass.RecordComponentInfo c) {
        TyVarEnv tenv = new TyVarEnv((Map<TyVarSymbol, TypeBoundClass.TyVarInfo>)info.typeParameterTypes());
        String desc = SigWriter.type(this.sig.signature(Erasure.erase(c.type(), (Function<TyVarSymbol, TypeBoundClass.TyVarInfo>)tenv)));
        String signature = this.sig.fieldSignature(c.type());
        ImmutableList.Builder typeAnnotations = ImmutableList.builder();
        this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)typeAnnotations, c.type(), ClassFile.TypeAnnotationInfo.TargetType.FIELD, ClassFile.TypeAnnotationInfo.EMPTY_TARGET);
        return new ClassFile.RecordInfo.RecordComponentInfo(c.name(), desc, signature, this.lowerAnnotations(c.annotations()), (ImmutableList<ClassFile.TypeAnnotationInfo>)typeAnnotations.build());
    }

    private ClassFile.MethodInfo lowerMethod(TypeBoundClass.MethodInfo m, ClassSymbol sym) {
        int access = m.access();
        TyVarEnv tenv = new TyVarEnv((Map<TyVarSymbol, TypeBoundClass.TyVarInfo>)m.tyParams());
        String name = m.name();
        String desc = this.methodDescriptor(m, tenv);
        String signature = this.sig.methodSignature(this.env, m, sym);
        ImmutableList.Builder exceptions = ImmutableList.builder();
        if (!m.exceptions().isEmpty()) {
            for (Type e : m.exceptions()) {
                exceptions.add((Object)this.sig.descriptor(((Type.ClassTy)Erasure.erase(e, (Function<TyVarSymbol, TypeBoundClass.TyVarInfo>)tenv)).sym()));
            }
        }
        ClassFile.AnnotationInfo.ElementValue defaultValue = m.defaultValue() != null ? this.annotationValue(m.defaultValue()) : null;
        ImmutableList<ClassFile.AnnotationInfo> annotations = this.lowerAnnotations(m.annotations());
        ImmutableList<ImmutableList<ClassFile.AnnotationInfo>> paramAnnotations = this.parameterAnnotations(m);
        ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotations = this.methodTypeAnnotations(m);
        ImmutableList<ClassFile.MethodInfo.ParameterInfo> parameters = this.methodParameters(m);
        return new ClassFile.MethodInfo(access, name, desc, signature, (List<String>)exceptions.build(), defaultValue, (List<ClassFile.AnnotationInfo>)annotations, paramAnnotations, typeAnnotations, parameters);
    }

    private ImmutableList<ClassFile.MethodInfo.ParameterInfo> methodParameters(TypeBoundClass.MethodInfo m) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.ParamInfo p : m.parameters()) {
            result.add((Object)new ClassFile.MethodInfo.ParameterInfo(p.name(), p.access() & 0x9010));
        }
        return result.build();
    }

    private ImmutableList<ImmutableList<ClassFile.AnnotationInfo>> parameterAnnotations(TypeBoundClass.MethodInfo m) {
        ImmutableList.Builder annotations = ImmutableList.builder();
        for (TypeBoundClass.ParamInfo parameter : m.parameters()) {
            if (parameter.synthetic()) continue;
            if (parameter.annotations().isEmpty()) {
                annotations.add((Object)ImmutableList.of());
                continue;
            }
            ImmutableList.Builder parameterAnnotations = ImmutableList.builder();
            for (AnnoInfo annotation : parameter.annotations()) {
                Boolean visible = this.isVisible(annotation.sym());
                if (visible == null) continue;
                String desc = this.sig.objectType(annotation.sym());
                parameterAnnotations.add((Object)new ClassFile.AnnotationInfo(desc, visible, (Map<String, ClassFile.AnnotationInfo.ElementValue>)this.annotationValues(annotation.values())));
            }
            annotations.add((Object)parameterAnnotations.build());
        }
        return annotations.build();
    }

    private String methodDescriptor(TypeBoundClass.MethodInfo m, Function<TyVarSymbol, TypeBoundClass.TyVarInfo> tenv) {
        ImmutableList typarams = ImmutableList.of();
        ImmutableList.Builder fparams = ImmutableList.builder();
        for (TypeBoundClass.ParamInfo t : m.parameters()) {
            fparams.add((Object)this.sig.signature(Erasure.erase(t.type(), tenv)));
        }
        Sig.TySig result = this.sig.signature(Erasure.erase(m.returnType(), tenv));
        ImmutableList excns = ImmutableList.of();
        return SigWriter.method(new Sig.MethodSig((ImmutableList<Sig.TyParamSig>)typarams, (ImmutableList<Sig.TySig>)fparams.build(), result, (ImmutableList<Sig.TySig>)excns));
    }

    private ClassFile.FieldInfo lowerField(TypeBoundClass.FieldInfo f) {
        String name = f.name();
        TyVarEnv tenv = new TyVarEnv((Map<TyVarSymbol, TypeBoundClass.TyVarInfo>)ImmutableMap.of());
        String desc = SigWriter.type(this.sig.signature(Erasure.erase(f.type(), (Function<TyVarSymbol, TypeBoundClass.TyVarInfo>)tenv)));
        String signature = this.sig.fieldSignature(f.type());
        ImmutableList<ClassFile.AnnotationInfo> annotations = this.lowerAnnotations(f.annotations());
        ImmutableList.Builder typeAnnotations = ImmutableList.builder();
        this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)typeAnnotations, f.type(), ClassFile.TypeAnnotationInfo.TargetType.FIELD, ClassFile.TypeAnnotationInfo.EMPTY_TARGET);
        return new ClassFile.FieldInfo(f.access(), name, desc, signature, f.value(), (List<ClassFile.AnnotationInfo>)annotations, (ImmutableList<ClassFile.TypeAnnotationInfo>)typeAnnotations.build());
    }

    private ImmutableList<ClassFile.InnerClass> collectInnerClasses(SourceFile source, ClassSymbol origin, SourceTypeBoundClass info) {
        LinkedHashSet<ClassSymbol> all = new LinkedHashSet<ClassSymbol>();
        this.addEnclosing(source, this.env, all, origin);
        for (ClassSymbol sym : info.children().values()) {
            this.addEnclosing(source, this.env, all, sym);
        }
        for (ClassSymbol sym : this.sig.classes) {
            this.addEnclosing(source, this.env, all, sym);
        }
        ImmutableList.Builder inners = ImmutableList.builder();
        for (ClassSymbol innerSym : all) {
            inners.add((Object)this.innerClass(this.env, innerSym));
        }
        return inners.build();
    }

    private void addEnclosing(SourceFile source, Env<ClassSymbol, TypeBoundClass> env, Set<ClassSymbol> all, ClassSymbol sym) {
        TypeBoundClass info = env.get(sym);
        if (info == null) {
            throw TurbineError.format(source, TurbineError.ErrorKind.CLASS_FILE_NOT_FOUND, sym);
        }
        ClassSymbol owner = info.owner();
        if (owner != null) {
            this.addEnclosing(source, env, all, owner);
            all.add(sym);
        }
    }

    private @Nullable String collectNestHost(SourceFile source, @Nullable ClassSymbol sym) {
        if (sym == null) {
            return null;
        }
        while (true) {
            TypeBoundClass info;
            if ((info = this.env.get(sym)) == null) {
                throw TurbineError.format(source, TurbineError.ErrorKind.CLASS_FILE_NOT_FOUND, sym);
            }
            if (info.owner() == null) {
                return this.sig.descriptor(sym);
            }
            sym = info.owner();
        }
    }

    private ImmutableList<String> collectNestMembers(SourceFile source, SourceTypeBoundClass info) {
        LinkedHashSet<ClassSymbol> nestMembers = new LinkedHashSet<ClassSymbol>();
        for (ClassSymbol child : info.children().values()) {
            Lower.addNestMembers(source, this.env, nestMembers, child);
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (ClassSymbol nestMember : nestMembers) {
            result.add((Object)this.sig.descriptor(nestMember));
        }
        return result.build();
    }

    private static void addNestMembers(SourceFile source, Env<ClassSymbol, TypeBoundClass> env, Set<ClassSymbol> nestMembers, ClassSymbol sym) {
        if (!nestMembers.add(sym)) {
            return;
        }
        TypeBoundClass info = env.get(sym);
        if (info == null) {
            throw TurbineError.format(source, TurbineError.ErrorKind.CLASS_FILE_NOT_FOUND, sym);
        }
        for (ClassSymbol child : info.children().values()) {
            Lower.addNestMembers(source, env, nestMembers, child);
        }
    }

    private ClassFile.InnerClass innerClass(Env<ClassSymbol, TypeBoundClass> env, ClassSymbol innerSym) {
        TypeBoundClass inner = env.getNonNull(innerSym);
        ClassSymbol owner = Objects.requireNonNull(inner.owner());
        String innerName = innerSym.binaryName().substring(owner.binaryName().length() + 1);
        int access = inner.access();
        return new ClassFile.InnerClass(innerSym.binaryName(), owner.binaryName(), innerName, access &= 0xFFFFF7DF);
    }

    private int classAccess(SourceTypeBoundClass info) {
        int access = info.access();
        if (((access &= 0xFFFFF7F5) & 4) != 0) {
            access &= 0xFFFFFFFB;
            access |= 1;
        }
        return access;
    }

    private ImmutableList<ClassFile.AnnotationInfo> lowerAnnotations(ImmutableList<AnnoInfo> annotations) {
        ImmutableList.Builder lowered = ImmutableList.builder();
        for (AnnoInfo annotation : annotations) {
            ClassFile.AnnotationInfo anno = this.lowerAnnotation(annotation);
            if (anno == null) continue;
            lowered.add((Object)anno);
        }
        return lowered.build();
    }

    private @Nullable ClassFile.AnnotationInfo lowerAnnotation(AnnoInfo annotation) {
        Boolean visible = this.isVisible(annotation.sym());
        if (visible == null) {
            return null;
        }
        return new ClassFile.AnnotationInfo(this.sig.objectType(annotation.sym()), visible, (Map<String, ClassFile.AnnotationInfo.ElementValue>)this.annotationValues(annotation.values()));
    }

    private @Nullable Boolean isVisible(ClassSymbol sym) {
        RetentionPolicy retention = Objects.requireNonNull(this.env.getNonNull(sym).annotationMetadata()).retention();
        switch (retention) {
            case CLASS: {
                return false;
            }
            case RUNTIME: {
                return true;
            }
            case SOURCE: {
                return null;
            }
        }
        throw new AssertionError((Object)retention);
    }

    private ImmutableMap<String, ClassFile.AnnotationInfo.ElementValue> annotationValues(ImmutableMap<String, Const> values) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry entry : values.entrySet()) {
            result.put((Object)((String)entry.getKey()), (Object)this.annotationValue((Const)entry.getValue()));
        }
        return result.buildOrThrow();
    }

    private ClassFile.AnnotationInfo.ElementValue annotationValue(Const value) {
        switch (value.kind()) {
            case CLASS_LITERAL: {
                TurbineClassValue classValue = (TurbineClassValue)value;
                return new ClassFile.AnnotationInfo.ElementValue.ConstTurbineClassValue(SigWriter.type(this.sig.signature(classValue.type())));
            }
            case ENUM_CONSTANT: {
                EnumConstantValue enumValue = (EnumConstantValue)value;
                return new ClassFile.AnnotationInfo.ElementValue.EnumConstValue(this.sig.objectType(enumValue.sym().owner()), enumValue.sym().name());
            }
            case ARRAY: {
                Const.ArrayInitValue arrayValue = (Const.ArrayInitValue)value;
                ArrayList<ClassFile.AnnotationInfo.ElementValue> values = new ArrayList<ClassFile.AnnotationInfo.ElementValue>();
                for (Const element : arrayValue.elements()) {
                    values.add(this.annotationValue(element));
                }
                return new ClassFile.AnnotationInfo.ElementValue.ArrayValue(values);
            }
            case ANNOTATION: {
                TurbineAnnotationValue annotationValue = (TurbineAnnotationValue)value;
                Boolean visible = this.isVisible(annotationValue.sym());
                if (visible == null) {
                    visible = true;
                }
                return new ClassFile.AnnotationInfo.ElementValue.ConstTurbineAnnotationValue(new ClassFile.AnnotationInfo(this.sig.objectType(annotationValue.sym()), visible, (Map<String, ClassFile.AnnotationInfo.ElementValue>)this.annotationValues(annotationValue.values())));
            }
            case PRIMITIVE: {
                return new ClassFile.AnnotationInfo.ElementValue.ConstValue((Const.Value)value);
            }
        }
        throw new AssertionError((Object)value.kind());
    }

    private ImmutableList<ClassFile.TypeAnnotationInfo> classTypeAnnotations(SourceTypeBoundClass info) {
        ImmutableList.Builder result = ImmutableList.builder();
        if (info.superClassType() != null) {
            this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, info.superClassType(), ClassFile.TypeAnnotationInfo.TargetType.SUPERTYPE, new ClassFile.TypeAnnotationInfo.SuperTypeTarget(-1));
        }
        int idx = 0;
        for (Type i : info.interfaceTypes()) {
            this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, i, ClassFile.TypeAnnotationInfo.TargetType.SUPERTYPE, new ClassFile.TypeAnnotationInfo.SuperTypeTarget(idx++));
        }
        this.typeParameterAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, (Iterable<TypeBoundClass.TyVarInfo>)info.typeParameterTypes().values(), ClassFile.TypeAnnotationInfo.TargetType.CLASS_TYPE_PARAMETER, ClassFile.TypeAnnotationInfo.TargetType.CLASS_TYPE_PARAMETER_BOUND);
        return result.build();
    }

    private ImmutableList<ClassFile.TypeAnnotationInfo> methodTypeAnnotations(TypeBoundClass.MethodInfo m) {
        ImmutableList.Builder result = ImmutableList.builder();
        this.typeParameterAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, (Iterable<TypeBoundClass.TyVarInfo>)m.tyParams().values(), ClassFile.TypeAnnotationInfo.TargetType.METHOD_TYPE_PARAMETER, ClassFile.TypeAnnotationInfo.TargetType.METHOD_TYPE_PARAMETER_BOUND);
        int idx = 0;
        for (Type e : m.exceptions()) {
            this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, e, ClassFile.TypeAnnotationInfo.TargetType.METHOD_THROWS, new ClassFile.TypeAnnotationInfo.ThrowsTarget(idx++));
        }
        if (m.receiver() != null) {
            this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, m.receiver().type(), ClassFile.TypeAnnotationInfo.TargetType.METHOD_RECEIVER_PARAMETER, ClassFile.TypeAnnotationInfo.EMPTY_TARGET);
        }
        this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, m.returnType(), ClassFile.TypeAnnotationInfo.TargetType.METHOD_RETURN, ClassFile.TypeAnnotationInfo.EMPTY_TARGET);
        idx = 0;
        for (TypeBoundClass.ParamInfo p : m.parameters()) {
            if (p.synthetic()) continue;
            this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, p.type(), ClassFile.TypeAnnotationInfo.TargetType.METHOD_FORMAL_PARAMETER, new ClassFile.TypeAnnotationInfo.FormalParameterTarget(idx++));
        }
        return result.build();
    }

    private void typeParameterAnnotations(ImmutableList.Builder<ClassFile.TypeAnnotationInfo> result, Iterable<TypeBoundClass.TyVarInfo> typeParameters, ClassFile.TypeAnnotationInfo.TargetType targetType, ClassFile.TypeAnnotationInfo.TargetType boundTargetType) {
        int typeParameterIndex = 0;
        for (TypeBoundClass.TyVarInfo p : typeParameters) {
            for (AnnoInfo anno : DisambiguateTypeAnnotations.groupRepeated(this.env, p.annotations())) {
                ClassFile.AnnotationInfo info = this.lowerAnnotation(anno);
                if (info == null) continue;
                result.add((Object)new ClassFile.TypeAnnotationInfo(targetType, new ClassFile.TypeAnnotationInfo.TypeParameterTarget(typeParameterIndex), ClassFile.TypeAnnotationInfo.TypePath.root(), info));
            }
            int boundIndex = 0;
            for (Type i : p.upperBound().bounds()) {
                if (boundIndex != 0 || this.isInterface(i, this.env)) {
                    // empty if block
                }
                int n = ++boundIndex;
                ++boundIndex;
                this.lowerTypeAnnotations(result, i, boundTargetType, new ClassFile.TypeAnnotationInfo.TypeParameterBoundTarget(typeParameterIndex, n));
            }
            ++typeParameterIndex;
        }
    }

    private boolean isInterface(Type type, Env<ClassSymbol, TypeBoundClass> env) {
        return type.tyKind() == Type.TyKind.CLASS_TY && env.getNonNull(((Type.ClassTy)type).sym()).kind() == TurbineTyKind.INTERFACE;
    }

    private void lowerTypeAnnotations(ImmutableList.Builder<ClassFile.TypeAnnotationInfo> result, Type type, ClassFile.TypeAnnotationInfo.TargetType targetType, ClassFile.TypeAnnotationInfo.Target target) {
        new LowerTypeAnnotations(result, targetType, target).lowerTypeAnnotations(type, ClassFile.TypeAnnotationInfo.TypePath.root());
    }

    class LowerTypeAnnotations {
        private final ImmutableList.Builder<ClassFile.TypeAnnotationInfo> result;
        private final ClassFile.TypeAnnotationInfo.TargetType targetType;
        private final ClassFile.TypeAnnotationInfo.Target target;

        public LowerTypeAnnotations(ImmutableList.Builder<ClassFile.TypeAnnotationInfo> result, ClassFile.TypeAnnotationInfo.TargetType targetType, ClassFile.TypeAnnotationInfo.Target target) {
            this.result = result;
            this.targetType = targetType;
            this.target = target;
        }

        private void lowerTypeAnnotations(Type type, ClassFile.TypeAnnotationInfo.TypePath path) {
            switch (type.tyKind()) {
                case TY_VAR: {
                    this.lowerTypeAnnotations(((Type.TyVar)type).annos(), path);
                    break;
                }
                case CLASS_TY: {
                    this.lowerClassTypeTypeAnnotations((Type.ClassTy)type, path);
                    break;
                }
                case ARRAY_TY: {
                    this.lowerArrayTypeAnnotations(type, path);
                    break;
                }
                case WILD_TY: {
                    this.lowerWildTyTypeAnnotations((Type.WildTy)type, path);
                    break;
                }
                case PRIM_TY: {
                    this.lowerTypeAnnotations(((Type.PrimTy)type).annos(), path);
                    break;
                }
                case VOID_TY: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)type.tyKind());
                }
            }
        }

        private void lowerTypeAnnotations(ImmutableList<AnnoInfo> annos, ClassFile.TypeAnnotationInfo.TypePath path) {
            for (AnnoInfo anno : DisambiguateTypeAnnotations.groupRepeated(Lower.this.env, annos)) {
                ClassFile.AnnotationInfo info = Lower.this.lowerAnnotation(anno);
                if (info == null) continue;
                this.result.add((Object)new ClassFile.TypeAnnotationInfo(this.targetType, this.target, path, info));
            }
        }

        private void lowerWildTyTypeAnnotations(Type.WildTy type, ClassFile.TypeAnnotationInfo.TypePath path) {
            switch (type.boundKind()) {
                case NONE: {
                    this.lowerTypeAnnotations(type.annotations(), path);
                    break;
                }
                case UPPER: 
                case LOWER: {
                    this.lowerTypeAnnotations(type.annotations(), path);
                    this.lowerTypeAnnotations(type.bound(), path.wild());
                }
            }
        }

        private void lowerArrayTypeAnnotations(Type type, ClassFile.TypeAnnotationInfo.TypePath path) {
            Type base = type;
            ArrayDeque<Type.ArrayTy> flat = new ArrayDeque<Type.ArrayTy>();
            while (base instanceof Type.ArrayTy) {
                Type.ArrayTy arrayTy = (Type.ArrayTy)base;
                flat.addFirst(arrayTy);
                base = arrayTy.elementType();
            }
            for (Type.ArrayTy arrayTy : flat) {
                this.lowerTypeAnnotations(arrayTy.annos(), path);
                path = path.array();
            }
            this.lowerTypeAnnotations(base, path);
        }

        private void lowerClassTypeTypeAnnotations(Type.ClassTy type, ClassFile.TypeAnnotationInfo.TypePath path) {
            for (Type.ClassTy.SimpleClassTy simple : type.classes()) {
                this.lowerTypeAnnotations(simple.annos(), path);
                int idx = 0;
                for (Type a : simple.targs()) {
                    this.lowerTypeAnnotations(a, path.typeArgument(idx++));
                }
                path = path.nested();
            }
        }
    }

    class TyVarEnv
    implements Function<TyVarSymbol, TypeBoundClass.TyVarInfo> {
        private final Map<TyVarSymbol, TypeBoundClass.TyVarInfo> tyParams;

        public TyVarEnv(Map<TyVarSymbol, TypeBoundClass.TyVarInfo> tyParams) {
            this.tyParams = tyParams;
        }

        public TypeBoundClass.TyVarInfo apply(TyVarSymbol sym) {
            TypeBoundClass.TyVarInfo result = this.tyParams.get(sym);
            if (result != null) {
                return result;
            }
            Symbol ownerSym = sym.owner();
            if (ownerSym.symKind() != Symbol.Kind.CLASS) {
                throw new AssertionError(sym);
            }
            TypeBoundClass owner = (TypeBoundClass)Lower.this.env.getNonNull((ClassSymbol)ownerSym);
            return (TypeBoundClass.TyVarInfo)owner.typeParameterTypes().get((Object)sym);
        }
    }

    public static class Lowered {
        private final ImmutableMap<String, byte[]> bytes;
        private final ImmutableSet<ClassSymbol> symbols;

        public Lowered(ImmutableMap<String, byte[]> bytes, ImmutableSet<ClassSymbol> symbols) {
            this.bytes = bytes;
            this.symbols = symbols;
        }

        public ImmutableMap<String, byte[]> bytes() {
            return this.bytes;
        }

        public ImmutableSet<ClassSymbol> symbols() {
            return this.symbols;
        }
    }
}

