/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractAsKeyOfSetOrMap;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;

@BugPattern(name="ProtosAsKeyOfSetOrMap", summary="Protos should not be used as a key to a map, in a set, or in a contains method on a descendant of a collection. Protos have non deterministic ordering and proto equality is deep, which is a performance issue.", severity=BugPattern.SeverityLevel.WARNING)
public class ProtosAsKeyOfSetOrMap
extends AbstractAsKeyOfSetOrMap {
    private static final Supplier<Type> COM_GOOGLE_PROTOBUF_GENERATEDMESSAGE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("com.google.protobuf.GeneratedMessage"));

    @Override
    protected boolean isBadType(Type type, VisitorState state) {
        return ASTHelpers.isSubtype((Type)type, (Type)((Type)COM_GOOGLE_PROTOBUF_GENERATEDMESSAGE.get(state)), (VisitorState)state);
    }
}

