/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.apidiff;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Resources;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.bugpatterns.apidiff.ApiDiff;
import com.google.errorprone.bugpatterns.apidiff.ApiDiffChecker;
import com.google.errorprone.bugpatterns.apidiff.ApiDiffProto;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;

@BugPattern(name="Java8ApiChecker", summary="Use of class, field, or method that is not compatible with JDK 8", explanation="Code that needs to be compatible with Java 8 cannot use types or members that are only present in newer class libraries", severity=BugPattern.SeverityLevel.ERROR)
public class Java8ApiChecker
extends ApiDiffChecker {
    private static final Pattern BUFFER = Pattern.compile("java/nio/.*Buffer");
    private static final String CHECKSUM = "java/util/zip/Checksum";

    private static ApiDiff loadApiDiff(ErrorProneFlags errorProneFlags) {
        try {
            byte[] diffData = Resources.toByteArray((URL)Resources.getResource(Java8ApiChecker.class, (String)"8to11diff.binarypb"));
            ApiDiff diff = ApiDiff.fromProto(((ApiDiffProto.Diff.Builder)ApiDiffProto.Diff.newBuilder().mergeFrom(diffData, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry())).build());
            boolean checkBuffer = errorProneFlags.getBoolean("Java8ApiChecker:checkBuffer").orElse(true);
            boolean checkChecksum = errorProneFlags.getBoolean("Java8ApiChecker:checkChecksum").orElse(true);
            if (checkBuffer && checkChecksum) {
                return diff;
            }
            ImmutableSetMultimap unsupportedMembers = (ImmutableSetMultimap)diff.unsupportedMembersByClass().entries().stream().filter(e -> checkBuffer || !BUFFER.matcher((CharSequence)e.getKey()).matches()).filter(e -> checkChecksum || !((String)e.getKey()).equals(CHECKSUM)).collect(ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, Map.Entry::getValue));
            return ApiDiff.fromMembers(diff.unsupportedClasses(), (Multimap<String, ApiDiff.ClassMemberKey>)unsupportedMembers);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    public Java8ApiChecker(ErrorProneFlags errorProneFlags) {
        super(Java8ApiChecker.loadApiDiff(errorProneFlags));
    }
}

