/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.refaster.AutoValue_UPlaceholderExpression;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.PlaceholderMethod;
import com.google.errorprone.refaster.PlaceholderUnificationVisitor;
import com.google.errorprone.refaster.PlaceholderVerificationVisitor;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UMatches;
import com.google.errorprone.refaster.UPrimitiveType;
import com.google.errorprone.refaster.UVariableDecl;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;
import java.util.Collection;
import java.util.Map;

@AutoValue
public abstract class UPlaceholderExpression
extends UExpression {
    static UPlaceholderExpression create(PlaceholderMethod placeholder, Iterable<? extends UExpression> arguments) {
        ImmutableList placeholderParams = placeholder.parameters().asList();
        ImmutableList argumentsList = ImmutableList.copyOf(arguments);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < placeholderParams.size(); ++i) {
            builder.put((Object)((UVariableDecl)placeholderParams.get(i)), (Object)((UExpression)argumentsList.get(i)));
        }
        return new AutoValue_UPlaceholderExpression(placeholder, (ImmutableMap<UVariableDecl, UExpression>)builder.buildOrThrow());
    }

    abstract PlaceholderMethod placeholder();

    abstract ImmutableMap<UVariableDecl, UExpression> arguments();

    static TreeCopier<Inliner> copier(final Map<UVariableDecl, UExpression> arguments, Inliner inliner) {
        return new TreeCopier<Inliner>(inliner.maker()){

            @Override
            public <T extends JCTree> T copy(T tree, Inliner inliner) {
                if (tree == null) {
                    return null;
                }
                T result = super.copy(tree, inliner);
                if (result.toString().equals(tree.toString())) {
                    return tree;
                }
                return result;
            }

            @Override
            public JCTree visitIdentifier(IdentifierTree node, Inliner inliner) {
                if (node instanceof PlaceholderParamIdent) {
                    try {
                        return (JCTree)((UExpression)arguments.get(((PlaceholderParamIdent)node).param)).inline(inliner);
                    }
                    catch (CouldNotResolveImportException e) {
                        throw new UncheckedCouldNotResolveImportException(e);
                    }
                }
                return super.visitIdentifier(node, inliner);
            }
        };
    }

    @Override
    public JCTree.JCExpression inline(Inliner inliner) throws CouldNotResolveImportException {
        try {
            return UPlaceholderExpression.copier(this.arguments(), inliner).copy(inliner.getBinding(this.placeholder().exprKey()), inliner);
        }
        catch (UncheckedCouldNotResolveImportException e) {
            throw e.getCause();
        }
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.OTHER;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitOther(this, data);
    }

    public boolean reverify(Unifier unifier) {
        return (Boolean)MoreObjects.firstNonNull((Object)new PlaceholderVerificationVisitor(Collections2.transform(this.placeholder().requiredParameters(), (Function)Functions.forMap(this.arguments())), (Collection<? extends UExpression>)this.arguments().values()).scan((Tree)unifier.getBinding(this.placeholder().exprKey()), unifier), (Object)true);
    }

    @Override
    protected Choice<Unifier> defaultAction(Tree node, Unifier unifier) {
        if (this.placeholder().returnType().equals(UPrimitiveType.VOID) || !(node instanceof JCTree.JCExpression)) {
            return Choice.none();
        }
        JCTree.JCExpression expr = (JCTree.JCExpression)node;
        PlaceholderVerificationVisitor verification = new PlaceholderVerificationVisitor(Collections2.transform(this.placeholder().requiredParameters(), (Function)Functions.forMap(this.arguments())), (Collection<? extends UExpression>)this.arguments().values());
        if (!verification.scan(node, unifier).booleanValue() || !verification.allRequiredMatched()) {
            return Choice.none();
        }
        Choice<? extends PlaceholderUnificationVisitor.State<? extends JCTree.JCExpression>> states = PlaceholderUnificationVisitor.create(TreeMaker.instance(unifier.getContext()), this.arguments()).unifyExpression(expr, PlaceholderUnificationVisitor.State.create(List.nil(), unifier, null));
        return states.thenOption(state -> {
            if (ImmutableSet.copyOf(state.seenParameters()).containsAll(this.placeholder().requiredParameters())) {
                Unifier resultUnifier = state.unifier();
                JCTree.JCExpression prevBinding = resultUnifier.getBinding(this.placeholder().exprKey());
                if (prevBinding != null) {
                    return prevBinding.toString().equals(((JCTree.JCExpression)state.result()).toString()) ? Optional.of((Object)resultUnifier) : Optional.absent();
                }
                JCTree.JCExpression result = (JCTree.JCExpression)state.result();
                if (!this.placeholder().matcher().matches((Tree)result, UMatches.makeVisitorState(expr, resultUnifier))) {
                    return Optional.absent();
                }
                result.type = expr.type;
                resultUnifier.putBinding(this.placeholder().exprKey(), result);
                return Optional.of((Object)resultUnifier);
            }
            return Optional.absent();
        });
    }

    static class UncheckedCouldNotResolveImportException
    extends RuntimeException {
        UncheckedCouldNotResolveImportException(CouldNotResolveImportException e) {
            super(e);
        }

        @Override
        public synchronized CouldNotResolveImportException getCause() {
            return (CouldNotResolveImportException)super.getCause();
        }
    }

    public static final class PlaceholderParamIdent
    extends JCTree.JCIdent {
        final UVariableDecl param;

        PlaceholderParamIdent(UVariableDecl param, Context context) {
            super(Names.instance(context).fromString(param.getName().contents()), null);
            this.param = (UVariableDecl)Preconditions.checkNotNull((Object)param);
        }
    }
}

