/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import java.util.Objects;

@BugPattern(summary="The non-constant portion of an equals check generally comes first. Prefer e.equals(CONSTANT) if e is non-null or Objects.equals(e, CONSTANT) if e may be", severity=BugPattern.SeverityLevel.WARNING)
public final class YodaCondition
extends BugChecker
implements BugChecker.BinaryTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        switch (tree.getKind()) {
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                return this.fix(tree, tree.getLeftOperand(), tree.getRightOperand(), false, state);
            }
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (Matchers.staticEqualsInvocation().matches((Tree)tree, state)) {
            return this.fix(tree, tree.getArguments().get(0), tree.getArguments().get(1), false, state);
        }
        if (Matchers.instanceEqualsInvocation().matches((Tree)tree, state)) {
            return this.fix(tree, ASTHelpers.getReceiver((ExpressionTree)tree), tree.getArguments().get(0), true, state);
        }
        return Description.NO_MATCH;
    }

    private Description fix(Tree tree, ExpressionTree lhs, ExpressionTree rhs, boolean provideNullSafeFix, VisitorState state) {
        if (YodaCondition.seemsConstant(lhs) && !YodaCondition.seemsConstant(rhs)) {
            Description.Builder description = this.buildDescription(lhs);
            if (provideNullSafeFix && !ASTHelpers.getNullnessValue((ExpressionTree)rhs, (VisitorState)state, (NullnessAnalysis)NullnessAnalysis.instance((Context)state.context)).equals((Object)Nullness.NONNULL)) {
                SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription("null-safe fix");
                description.addFix((Fix)fix.replace(tree, String.format("%s.equals(%s, %s)", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)Objects.class.getName()), state.getSourceForNode((Tree)rhs), state.getSourceForNode((Tree)lhs))).build());
            }
            return description.addFix((Fix)SuggestedFix.swap((Tree)lhs, (Tree)rhs)).build();
        }
        return Description.NO_MATCH;
    }

    private static boolean seemsConstant(Tree tree) {
        if (ASTHelpers.constValue((Tree)tree) != null) {
            return true;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        return symbol instanceof Symbol.VarSymbol && symbol.isEnum();
    }
}

