/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import java.util.OptionalDouble;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class OptionalDoubleSubject
extends Subject {
    private final OptionalDouble actual;

    OptionalDoubleSubject(FailureMetadata failureMetadata, @NullableDecl OptionalDouble subject, @NullableDecl String typeDescription) {
        super(failureMetadata, (Object)subject, typeDescription);
        this.actual = subject;
    }

    public void isPresent() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact((String)"expected present optional"), new Fact[0]);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact((String)"expected to be present"), new Fact[0]);
        }
    }

    public void isEmpty() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact((String)"expected empty optional"), new Fact[0]);
        } else if (this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact((String)"expected to be empty"), new Fact[]{Fact.fact((String)"but was present with value", (Object)this.actual.getAsDouble())});
        }
    }

    public void hasValue(double expected) {
        if (this.actual == null) {
            this.failWithActual("expected an optional with value", expected);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.fact((String)"expected to have value", (Object)expected), new Fact[]{Fact.simpleFact((String)"but was absent")});
        } else {
            this.checkNoNeedToDisplayBothValues("getAsDouble()", new Object[0]).that(Double.valueOf(this.actual.getAsDouble())).isEqualTo((Object)expected);
        }
    }

    public static Subject.Factory<OptionalDoubleSubject, OptionalDouble> optionalDoubles() {
        return (metadata, subject) -> new OptionalDoubleSubject(metadata, (OptionalDouble)subject, "optionalDouble");
    }
}

