/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.io.Serializable;

@BugPattern(summary="Avoid hash-based containers of java.net.URL--the containers rely on equals() and hashCode(), which cause java.net.URL to make blocking internet connections.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class URLEqualsHashCode
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final String URL_CLASS = "java.net.URL";
    private static final Matcher<ExpressionTree> CONTAINER_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{new URLTypeArgumentMatcher("java.util.Set", 0), new URLTypeArgumentMatcher("java.util.Map", 0), new URLTypeArgumentMatcher("com.google.common.collect.BiMap", 1)});
    private static final Matcher<ExpressionTree> METHOD_INVOCATION_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClassAny(new String[]{ImmutableSet.class.getName(), ImmutableMap.class.getName(), HashBiMap.class.getName()}), MethodMatchers.instanceMethod().onExactClassAny(new String[]{ImmutableSet.Builder.class.getName(), ImmutableMap.Builder.class.getName()}).named("build")}), CONTAINER_MATCHER});
    private static final Supplier<Type> JAVA_NET_URL = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString(URL_CLASS));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (METHOD_INVOCATION_MATCHER.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (CONTAINER_MATCHER.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static class URLTypeArgumentMatcher
    implements Matcher<Tree> {
        private final String clazz;
        private final int typeArgumentIndex;

        URLTypeArgumentMatcher(String clazz, int index) {
            this.clazz = clazz;
            this.typeArgumentIndex = index;
        }

        public boolean matches(Tree tree, VisitorState state) {
            Symbol sym = state.getSymbolFromString(this.clazz);
            if (sym == null) {
                return false;
            }
            Type type = ASTHelpers.getType((Tree)tree);
            if (!ASTHelpers.isSubtype((Type)type, (Type)sym.type, (VisitorState)state)) {
                return false;
            }
            Types types = state.getTypes();
            Type superType = types.asSuper(type, sym);
            if (superType == null) {
                return false;
            }
            List<Type> typeArguments = superType.getTypeArguments();
            if (typeArguments.isEmpty()) {
                return false;
            }
            return ASTHelpers.isSameType((Type)((Type)typeArguments.get(this.typeArgumentIndex)), (Type)((Type)JAVA_NET_URL.get(state)), (VisitorState)state);
        }
    }
}

